/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class HighlightInfoFilterImpl
implements HighlightInfoFilter {
    @Override
    public boolean accept(@NotNull HighlightInfo info, PsiFile file2) {
        if (file2 != null && file2.getOriginalFile() instanceof PsiCompiledFile) {
            return info.getSeverity() == HighlightInfoType.SYMBOL_TYPE_SEVERITY;
        }
        if (Holder.ourTestMode) {
            return true;
        }
        TextAttributes attributes = info.getTextAttributes((PsiElement)file2, null);
        return attributes == TextAttributes.ERASE_MARKER || attributes != null && (!attributes.isEmpty() || info.getSeverity() != HighlightSeverity.INFORMATION || info.getGutterIconRenderer() != null || info.getToolTip() != null);
    }

    private static class Holder {
        private static final boolean ourTestMode = ApplicationManager.getApplication().isUnitTestMode();

        private Holder() {
        }
    }
}

