/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.ErrorStripeUpdateManager;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.HighlightingSession;
import com.intellij.codeInsight.daemon.impl.HighlightingSessionImpl;
import com.intellij.codeInsight.daemon.impl.ShowAutoImportPassFactory;
import com.intellij.codeInsight.daemon.impl.TextEditorHighlightingPassRegistrarImpl;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.impl.EditorMarkupModelImpl;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.util.Alarm;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultHighlightInfoProcessor
extends HighlightInfoProcessor {
    private final Alarm repaintIconAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);

    @Override
    public void highlightsInsideVisiblePartAreProduced(@NotNull HighlightingSession session2, @Nullable Editor editor, @NotNull List<? extends HighlightInfo> infos, @NotNull TextRange priorityRange, @NotNull TextRange restrictRange, int groupId2) {
        PsiFile psiFile = session2.getPsiFile();
        Project project = psiFile.getProject();
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile);
        if (document == null) {
            return;
        }
        long modificationStamp = document.getModificationStamp();
        TextRange priorityIntersection = priorityRange.intersection(restrictRange);
        ArrayList<? extends HighlightInfo> infoCopy = new ArrayList<HighlightInfo>(infos);
        ((HighlightingSessionImpl)session2).applyInEDT(() -> {
            if (modificationStamp != document.getModificationStamp()) {
                return;
            }
            if (priorityIntersection != null) {
                MarkupModel markupModel = DocumentMarkupModel.forDocument(document, project, true);
                EditorColorsScheme scheme = session2.getColorsScheme();
                UpdateHighlightersUtil.setHighlightersInRange(project, document, priorityIntersection, scheme, infoCopy, (MarkupModelEx)markupModel, groupId2);
            }
            if (editor != null && !editor.isDisposed()) {
                ShowAutoImportPassFactory siFactory;
                TextEditorHighlightingPass highlightingPass;
                if (!DumbService.isDumb((Project)project) && (highlightingPass = (siFactory = (ShowAutoImportPassFactory)TextEditorHighlightingPassRegistrarImpl.EP_NAME.findExtensionOrFail(ShowAutoImportPassFactory.class)).createHighlightingPass(psiFile, editor)) != null) {
                    highlightingPass.doApplyInformationToEditor();
                }
                DefaultHighlightInfoProcessor.repaintErrorStripeAndIcon(editor, project);
            }
        });
    }

    static void repaintErrorStripeAndIcon(@NotNull Editor editor, @NotNull Project project) {
        MarkupModel markup = editor.getMarkupModel();
        if (markup instanceof EditorMarkupModelImpl) {
            ((EditorMarkupModelImpl)markup).repaintTrafficLightIcon();
        }
        ErrorStripeUpdateManager.getInstance(project).repaintErrorStripePanel(editor);
    }

    @Override
    public void highlightsOutsideVisiblePartAreProduced(@NotNull HighlightingSession session2, @Nullable Editor editor, @NotNull List<? extends HighlightInfo> infos, @NotNull TextRange priorityRange, @NotNull TextRange restrictedRange, int groupId2) {
        PsiFile psiFile = session2.getPsiFile();
        Project project = psiFile.getProject();
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile);
        if (document == null) {
            return;
        }
        long modificationStamp = document.getModificationStamp();
        ((HighlightingSessionImpl)session2).applyInEDT(() -> {
            if (project.isDisposed() || modificationStamp != document.getModificationStamp()) {
                return;
            }
            EditorColorsScheme scheme = session2.getColorsScheme();
            UpdateHighlightersUtil.setHighlightersOutsideRange(project, document, psiFile, infos, scheme, restrictedRange.getStartOffset(), restrictedRange.getEndOffset(), ProperTextRange.create((Segment)priorityRange), groupId2);
            if (editor != null) {
                DefaultHighlightInfoProcessor.repaintErrorStripeAndIcon(editor, project);
            }
        });
    }

    @Override
    public void allHighlightsForRangeAreProduced(@NotNull HighlightingSession session2, @NotNull TextRange elementRange, @Nullable List<? extends HighlightInfo> infos) {
        DefaultHighlightInfoProcessor.killAbandonedHighlightsUnder(session2.getProject(), session2.getDocument(), elementRange, infos, session2);
    }

    private static void killAbandonedHighlightsUnder(@NotNull Project project, @NotNull Document document, @NotNull TextRange range2, @Nullable List<? extends HighlightInfo> infos, @NotNull HighlightingSession highlightingSession) {
        DaemonCodeAnalyzerEx.processHighlights(document, project, null, range2.getStartOffset(), range2.getEndOffset(), (Processor<? super HighlightInfo>)((Processor)existing -> {
            if (existing.isBijective() && existing.getGroup() == 4 && range2.equalsToRange(existing.getActualStartOffset(), existing.getActualEndOffset())) {
                if (infos != null) {
                    for (HighlightInfo created : infos) {
                        if (!existing.equalsByActualOffset(created)) continue;
                        return true;
                    }
                }
                ((HighlightingSessionImpl)highlightingSession).queueDisposeHighlighterFor((HighlightInfo)existing);
            }
            return true;
        }));
    }

    @Override
    public void infoIsAvailable(@NotNull HighlightingSession session2, @NotNull HighlightInfo info, @NotNull TextRange priorityRange, @NotNull TextRange restrictedRange, int groupId2) {
        ((HighlightingSessionImpl)session2).queueHighlightInfo(info, restrictedRange, groupId2);
    }

    @Override
    public void progressIsAdvanced(@NotNull HighlightingSession highlightingSession, @Nullable Editor editor, double progress2) {
        PsiFile file2 = highlightingSession.getPsiFile();
        this.repaintTrafficIcon(file2, editor, progress2);
    }

    private void repaintTrafficIcon(@NotNull PsiFile file2, @Nullable Editor editor, double progress2) {
        if (ApplicationManager.getApplication().isCommandLine()) {
            return;
        }
        if (this.repaintIconAlarm.isEmpty() || progress2 >= 1.0) {
            this.repaintIconAlarm.addRequest(() -> {
                Project myProject = file2.getProject();
                if (myProject.isDisposed()) {
                    return;
                }
                Editor myeditor = editor;
                if (myeditor == null) {
                    myeditor = PsiEditorUtil.findEditor((PsiElement)file2);
                }
                if (myeditor != null && !myeditor.isDisposed()) {
                    DefaultHighlightInfoProcessor.repaintErrorStripeAndIcon(myeditor, myProject);
                }
            }, 50, null);
        }
    }
}

