/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.StandardProgressIndicator;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorBase;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TraceableDisposable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DaemonProgressIndicator
extends AbstractProgressIndicatorBase
implements StandardProgressIndicator,
Disposable {
    private static boolean debug;
    private final TraceableDisposable myTraceableDisposable = new TraceableDisposable(debug);
    private volatile boolean myDisposed;
    private volatile Throwable myCancellationCause;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void stop() {
        Object object = this.getLock();
        synchronized (object) {
            super.stop();
            this.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopIfRunning() {
        Object object = this.getLock();
        synchronized (object) {
            if (this.isRunning()) {
                this.stop();
            } else {
                this.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void cancel() {
        boolean changed2 = false;
        Object object = this.getLock();
        synchronized (object) {
            if (!this.isCanceled()) {
                this.myTraceableDisposable.kill("Daemon Progress Canceled");
                super.cancel();
                changed2 = true;
            }
        }
        if (changed2) {
            Disposer.dispose((Disposable)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cancel(@NotNull Throwable cause) {
        boolean changed2 = false;
        Object object = this.getLock();
        synchronized (object) {
            if (!this.isCanceled()) {
                this.myCancellationCause = cause;
                this.myTraceableDisposable.killExceptionally(cause);
                super.cancel();
                changed2 = true;
            }
        }
        if (changed2) {
            Disposer.dispose((Disposable)this);
        }
    }

    public void dispose() {
        this.myDisposed = true;
    }

    @Override
    public final boolean isCanceled() {
        return super.isCanceled();
    }

    @Override
    public final void checkCanceled() {
        super.checkCanceled();
    }

    @Override
    @Nullable
    protected Throwable getCancellationTrace() {
        Throwable cause = this.myCancellationCause;
        return cause != null ? cause : super.getCancellationTrace();
    }

    @Override
    public final void start() {
        this.checkCanceled();
        assert (!this.isRunning()) : "running";
        super.start();
    }

    public static void setDebug(boolean debug) {
        DaemonProgressIndicator.debug = debug;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        return super.toString() + (debug ? "; " + this.myTraceableDisposable.getStackTrace() + "\n;" : "");
    }

    final boolean isDisposed() {
        return this.myDisposed;
    }
}

