/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion.impl;

import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.codeInsight.completion.impl.RealPrefixMatchingWeigher;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.util.containers.FList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BetterPrefixMatcher
extends PrefixMatcher {
    private final PrefixMatcher myOriginal;
    @Nullable
    private final CamelHumpMatcher myHumpMatcher;
    private final int myMinMatchingDegree;

    public BetterPrefixMatcher(PrefixMatcher original, int minMatchingDegree) {
        super(original.getPrefix());
        this.myOriginal = original;
        this.myHumpMatcher = original instanceof CamelHumpMatcher ? (CamelHumpMatcher)original : null;
        this.myMinMatchingDegree = minMatchingDegree;
    }

    @NotNull
    public BetterPrefixMatcher improve(CompletionResult result2) {
        int degree = RealPrefixMatchingWeigher.getBestMatchingDegree(result2.getLookupElement(), result2.getPrefixMatcher());
        if (degree <= this.myMinMatchingDegree) {
            return this;
        }
        return this.createCopy(this.myOriginal, degree);
    }

    @NotNull
    protected BetterPrefixMatcher createCopy(PrefixMatcher original, int degree) {
        return new BetterPrefixMatcher(original, degree);
    }

    public boolean prefixMatches(@NotNull String name) {
        return this.prefixMatchesEx(name) == MatchingOutcome.BETTER_MATCH;
    }

    protected MatchingOutcome prefixMatchesEx(String name) {
        return this.myHumpMatcher != null ? this.matchOptimized(name, this.myHumpMatcher) : this.matchGeneric(name);
    }

    private MatchingOutcome matchGeneric(String name) {
        if (!this.myOriginal.prefixMatches(name)) {
            return MatchingOutcome.NON_MATCH;
        }
        if (!this.myOriginal.isStartMatch(name)) {
            return MatchingOutcome.WORSE_MATCH;
        }
        return this.myOriginal.matchingDegree(name) >= this.myMinMatchingDegree ? MatchingOutcome.BETTER_MATCH : MatchingOutcome.WORSE_MATCH;
    }

    private MatchingOutcome matchOptimized(String name, CamelHumpMatcher matcher) {
        FList<TextRange> fragments = matcher.matchingFragments(name);
        if (fragments == null) {
            return MatchingOutcome.NON_MATCH;
        }
        if (!MinusculeMatcher.isStartMatch(fragments)) {
            return MatchingOutcome.WORSE_MATCH;
        }
        return matcher.matchingDegree(name, fragments) >= this.myMinMatchingDegree ? MatchingOutcome.BETTER_MATCH : MatchingOutcome.WORSE_MATCH;
    }

    public boolean isStartMatch(String name) {
        return this.myOriginal.isStartMatch(name);
    }

    public int matchingDegree(String string) {
        return this.myOriginal.matchingDegree(string);
    }

    @NotNull
    public PrefixMatcher cloneWithPrefix(@NotNull String prefix) {
        return this.createCopy(this.myOriginal.cloneWithPrefix(prefix), this.myMinMatchingDegree);
    }

    public static class AutoRestarting
    extends BetterPrefixMatcher {
        private final CompletionResultSet myResult;

        public AutoRestarting(@NotNull CompletionResultSet result2) {
            this(result2, result2.getPrefixMatcher(), Integer.MIN_VALUE);
        }

        private AutoRestarting(CompletionResultSet result2, PrefixMatcher original, int minMatchingDegree) {
            super(original, minMatchingDegree);
            this.myResult = result2;
        }

        @Override
        @NotNull
        protected BetterPrefixMatcher createCopy(PrefixMatcher original, int degree) {
            return new AutoRestarting(this.myResult, original, degree);
        }

        @Override
        protected MatchingOutcome prefixMatchesEx(String name) {
            MatchingOutcome outcome = super.prefixMatchesEx(name);
            if (outcome == MatchingOutcome.WORSE_MATCH) {
                this.myResult.restartCompletionOnAnyPrefixChange();
            }
            return outcome;
        }
    }

    protected static enum MatchingOutcome {
        NON_MATCH,
        WORSE_MATCH,
        BETTER_MATCH;

    }
}

