/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.CompletionWeigher;
import com.intellij.codeInsight.completion.StatisticsComparable;
import com.intellij.codeInsight.lookup.Classifier;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.statistics.StatisticsInfo;
import com.intellij.psi.statistics.StatisticsManager;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StatisticsWeigher
extends CompletionWeigher {
    private static final Logger LOG = Logger.getInstance(LookupStatisticsWeigher.class);
    private static final Key<StatisticsInfo> BASE_STATISTICS_INFO = Key.create((String)"Base statistics info");

    public Comparable weigh(@NotNull LookupElement item, @NotNull CompletionLocation location) {
        throw new UnsupportedOperationException();
    }

    public static void clearBaseStatisticsInfo(LookupElement item) {
        item.putUserData(BASE_STATISTICS_INFO, null);
    }

    @NotNull
    public static StatisticsInfo getBaseStatisticsInfo(LookupElement item, @Nullable CompletionLocation location) {
        StatisticsInfo info = (StatisticsInfo)BASE_STATISTICS_INFO.get((UserDataHolder)item);
        if (info == null) {
            if (location == null) {
                return StatisticsInfo.EMPTY;
            }
            info = StatisticsWeigher.calcBaseInfo(item, location);
            BASE_STATISTICS_INFO.set((UserDataHolder)item, (Object)info);
        }
        return info;
    }

    @NotNull
    private static StatisticsInfo calcBaseInfo(LookupElement item, @NotNull CompletionLocation location) {
        StatisticsInfo info;
        if (!ApplicationManager.getApplication().isUnitTestMode() && !location.getCompletionParameters().isTestingMode()) {
            LOG.assertTrue(!ApplicationManager.getApplication().isDispatchThread());
        }
        return (info = StatisticsManager.serialize((Key)CompletionService.STATISTICS_KEY, (Object)item, (Object)location)) == null ? StatisticsInfo.EMPTY : info;
    }

    public static class LookupStatisticsWeigher
    extends Classifier<LookupElement> {
        private final CompletionLocation myLocation;
        private final Map<LookupElement, StatisticsComparable> myWeights = new IdentityHashMap<LookupElement, StatisticsComparable>();
        private final Set<String> myStringsWithWeights = new ObjectOpenHashSet();
        private final Set<LookupElement> myNoStats = new ReferenceOpenHashSet();

        public LookupStatisticsWeigher(CompletionLocation location, Classifier<LookupElement> next) {
            super(next, "stats");
            this.myLocation = location;
        }

        @Override
        public void addElement(@NotNull LookupElement element2, @NotNull ProcessingContext context) {
            StatisticsInfo baseInfo = StatisticsWeigher.getBaseStatisticsInfo(element2, this.myLocation);
            int weight2 = LookupStatisticsWeigher.weigh(baseInfo);
            if (weight2 != 0) {
                this.myWeights.put(element2, new StatisticsComparable(weight2, baseInfo));
                this.myStringsWithWeights.add(element2.getLookupString());
            }
            if (baseInfo == StatisticsInfo.EMPTY) {
                this.myNoStats.add(element2);
            }
            super.addElement(element2, context);
        }

        @Override
        @NotNull
        public Iterable<LookupElement> classify(@NotNull Iterable<? extends LookupElement> source, @NotNull ProcessingContext context) {
            List<LookupElement> initialList = this.getInitialNoStatElements(source, context);
            Iterable<LookupElement> rest = LookupStatisticsWeigher.withoutInitial(source, initialList);
            Collection byWeight = this.buildMapByWeight(rest).descendingMap().values();
            return JBIterable.from(initialList).append((Iterable)JBIterable.from(byWeight).flatten(group -> this.myNext.classify(group, context)));
        }

        private static Iterable<LookupElement> withoutInitial(Iterable<? extends LookupElement> allItems, List<? extends LookupElement> initial) {
            ReferenceOpenHashSet initialSet = new ReferenceOpenHashSet(initial);
            return JBIterable.from(allItems).filter(arg_0 -> LookupStatisticsWeigher.lambda$withoutInitial$1((Set)initialSet, arg_0));
        }

        private List<LookupElement> getInitialNoStatElements(Iterable<? extends LookupElement> source, ProcessingContext context) {
            ArrayList<LookupElement> initialList = new ArrayList<LookupElement>();
            for (LookupElement lookupElement : this.myNext.classify(source, context)) {
                if (!this.myNoStats.contains(lookupElement)) break;
                initialList.add(lookupElement);
            }
            return initialList;
        }

        private TreeMap<Integer, List<LookupElement>> buildMapByWeight(Iterable<? extends LookupElement> source) {
            MultiMap byName = MultiMap.create();
            ArrayList<LookupElement> noStats = new ArrayList<LookupElement>();
            for (LookupElement lookupElement : source) {
                String string = lookupElement.getLookupString();
                if (this.myStringsWithWeights.contains(string)) {
                    byName.putValue((Object)string, (Object)lookupElement);
                    continue;
                }
                noStats.add(lookupElement);
            }
            TreeMap<Integer, List<LookupElement>> map2 = new TreeMap<Integer, List<LookupElement>>();
            map2.put(0, noStats);
            for (String s : byName.keySet()) {
                List group = (List)byName.get((Object)s);
                group.sort(Comparator.comparing(this::getScalarWeight).reversed());
                map2.computeIfAbsent(this.getMaxWeight(group), __ -> new ArrayList()).addAll(group);
            }
            return map2;
        }

        private int getMaxWeight(List<? extends LookupElement> group) {
            int max = 0;
            for (int i2 = 0; i2 < group.size(); ++i2) {
                max = Math.max(max, this.getScalarWeight(group.get(i2)));
            }
            return max;
        }

        private int getScalarWeight(LookupElement e) {
            StatisticsComparable comparable = this.myWeights.get(e);
            return comparable == null ? 0 : comparable.getScalar();
        }

        private StatisticsComparable getWeight(LookupElement t) {
            StatisticsComparable w = this.myWeights.get(t);
            if (w == null) {
                StatisticsInfo info = StatisticsWeigher.getBaseStatisticsInfo(t, this.myLocation);
                w = new StatisticsComparable(LookupStatisticsWeigher.weigh(info), info);
                this.myWeights.put(t, w);
            }
            return w;
        }

        private static int weigh(StatisticsInfo baseInfo) {
            if (baseInfo == StatisticsInfo.EMPTY) {
                return 0;
            }
            int minRecency = StatisticsManager.getInstance().getLastUseRecency(baseInfo);
            return minRecency == Integer.MAX_VALUE ? 0 : 10000 - minRecency;
        }

        @Override
        @NotNull
        public List<Pair<LookupElement, Object>> getSortingWeights(@NotNull Iterable<? extends LookupElement> items, @NotNull ProcessingContext context) {
            return ContainerUtil.map(items, lookupElement -> new Pair(lookupElement, (Object)this.getWeight((LookupElement)lookupElement)));
        }

        @Override
        public void removeElement(@NotNull LookupElement element2, @NotNull ProcessingContext context) {
            this.myWeights.remove(element2);
            this.myNoStats.remove(element2);
            super.removeElement(element2, context);
        }

        private static /* synthetic */ boolean lambda$withoutInitial$1(Set initialSet, LookupElement element2) {
            return !initialSet.contains(element2);
        }
    }
}

