/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.actions.AbstractLayoutCodeProcessor;
import com.intellij.codeInsight.actions.VcsFacade;
import com.intellij.formatting.FormattingProgressTask;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.ex.util.EditorScrollingPositionKeeper;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.codeStyle.ChangedRangesInfo;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.FutureTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReformatCodeProcessor
extends AbstractLayoutCodeProcessor {
    private static final Logger LOG = Logger.getInstance(ReformatCodeProcessor.class);
    private final Collection<TextRange> myRanges = new ArrayList<TextRange>();
    private SelectionModel mySelectionModel;

    public ReformatCodeProcessor(Project project, boolean processChangedTextOnly) {
        super(project, ReformatCodeProcessor.getCommandName(), ReformatCodeProcessor.getProgressText(), processChangedTextOnly);
    }

    public ReformatCodeProcessor(@NotNull PsiFile file2, @NotNull SelectionModel selectionModel) {
        super(file2.getProject(), file2, ReformatCodeProcessor.getProgressText(), ReformatCodeProcessor.getCommandName(), false);
        this.mySelectionModel = selectionModel;
    }

    public ReformatCodeProcessor(AbstractLayoutCodeProcessor processor2, @NotNull SelectionModel selectionModel) {
        super(processor2, ReformatCodeProcessor.getCommandName(), ReformatCodeProcessor.getProgressText());
        this.mySelectionModel = selectionModel;
    }

    public ReformatCodeProcessor(AbstractLayoutCodeProcessor processor2, boolean processChangedTextOnly) {
        super(processor2, ReformatCodeProcessor.getCommandName(), ReformatCodeProcessor.getProgressText());
        this.setProcessChangedTextOnly(processChangedTextOnly);
    }

    public ReformatCodeProcessor(Project project, Module module, boolean processChangedTextOnly) {
        super(project, module, ReformatCodeProcessor.getCommandName(), ReformatCodeProcessor.getProgressText(), processChangedTextOnly);
    }

    public ReformatCodeProcessor(Project project, PsiDirectory directory, boolean includeSubdirs, boolean processChangedTextOnly) {
        super(project, directory, includeSubdirs, ReformatCodeProcessor.getProgressText(), ReformatCodeProcessor.getCommandName(), processChangedTextOnly);
    }

    public ReformatCodeProcessor(Project project, PsiFile file2, @Nullable TextRange range2, boolean processChangedTextOnly) {
        super(project, file2, ReformatCodeProcessor.getProgressText(), ReformatCodeProcessor.getCommandName(), processChangedTextOnly);
        if (range2 != null) {
            this.myRanges.add(range2);
        }
    }

    public ReformatCodeProcessor(@NotNull PsiFile file2, boolean processChangedTextOnly) {
        super(file2.getProject(), file2, ReformatCodeProcessor.getProgressText(), ReformatCodeProcessor.getCommandName(), processChangedTextOnly);
    }

    public ReformatCodeProcessor(Project project, PsiFile[] files2, @Nullable Runnable postRunnable, boolean processChangedTextOnly) {
        this(project, files2, ReformatCodeProcessor.getCommandName(), postRunnable, processChangedTextOnly);
    }

    public ReformatCodeProcessor(Project project, PsiFile[] files2, String commandName, @Nullable Runnable postRunnable, boolean processChangedTextOnly) {
        super(project, files2, ReformatCodeProcessor.getProgressText(), commandName, postRunnable, processChangedTextOnly);
    }

    @Override
    @NotNull
    protected FutureTask<Boolean> prepareTask(@NotNull PsiFile file2, boolean processChangedTextOnly) throws IncorrectOperationException {
        return new FutureTask<Boolean>(() -> {
            FormattingProgressTask.FORMATTING_CANCELLED_FLAG.set(false);
            try {
                PsiFile fileToProcess = ReformatCodeProcessor.ensureValid(file2);
                if (fileToProcess == null) {
                    Boolean bl = false;
                    return bl;
                }
                CharSequence before = null;
                Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(fileToProcess);
                if (this.getInfoCollector() != null) {
                    LOG.assertTrue(document != null);
                    before = document.getImmutableCharSequence();
                }
                EditorScrollingPositionKeeper.perform(document, true, () -> {
                    if (processChangedTextOnly) {
                        ChangedRangesInfo info = VcsFacade.getInstance().getChangedRangesInfo(fileToProcess);
                        if (info != null) {
                            ReformatCodeProcessor.assertFileIsValid(fileToProcess);
                            CodeStyleManager.getInstance((Project)this.myProject).reformatTextWithContext(fileToProcess, info);
                        }
                    } else {
                        Collection<TextRange> ranges = this.getRangesToFormat(fileToProcess);
                        CodeStyleManager.getInstance((Project)this.myProject).reformatText(fileToProcess, ranges);
                    }
                });
                if (before != null) {
                    this.prepareUserNotificationMessage(document, before);
                }
                Boolean bl = FormattingProgressTask.FORMATTING_CANCELLED_FLAG.get() == false;
                return bl;
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
                Boolean bl = false;
                return bl;
            }
            finally {
                this.myRanges.clear();
            }
        });
    }

    @Nullable
    private static PsiFile ensureValid(@NotNull PsiFile file2) {
        if (file2.isValid()) {
            return file2;
        }
        VirtualFile virtualFile = file2.getVirtualFile();
        if (!virtualFile.isValid()) {
            return null;
        }
        FileViewProvider provider = file2.getManager().findViewProvider(virtualFile);
        if (provider == null) {
            return null;
        }
        Language language = file2.getLanguage();
        return provider.hasLanguage(language) ? provider.getPsi(language) : provider.getPsi(provider.getBaseLanguage());
    }

    private static void assertFileIsValid(@NotNull PsiFile file2) {
        if (!file2.isValid()) {
            LOG.error("Invalid Psi file, name: " + file2.getName() + " , class: " + file2.getClass().getSimpleName() + " , " + PsiInvalidElementAccessException.findOutInvalidationReason((PsiElement)file2));
        }
    }

    private void prepareUserNotificationMessage(@NotNull Document document, @NotNull CharSequence before) {
        LOG.assertTrue(this.getInfoCollector() != null);
        int number = VcsFacade.getInstance().calculateChangedLinesNumber(document, before);
        if (number > 0) {
            String message = "formatted " + number + " line" + (number > 1 ? "s" : "");
            this.getInfoCollector().setReformatCodeNotification(message);
        }
    }

    @NotNull
    private Collection<TextRange> getRangesToFormat(PsiFile file2) {
        if (this.mySelectionModel != null) {
            return ReformatCodeProcessor.getSelectedRanges(this.mySelectionModel);
        }
        return !this.myRanges.isEmpty() ? this.myRanges : ContainerUtil.newArrayList((Object[])new TextRange[]{file2.getTextRange()});
    }

    private static String getProgressText() {
        return CodeInsightBundle.message((String)"reformat.progress.common.text", (Object[])new Object[0]);
    }

    public static String getCommandName() {
        return CodeInsightBundle.message((String)"process.reformat.code", (Object[])new Object[0]);
    }
}

