/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.CompactVirtualFileSet;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class FileRecursiveIterator {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Collection<? extends VirtualFile> myRoots;

    FileRecursiveIterator(@NotNull Project project, @NotNull List<? extends PsiFile> roots) {
        this(project, ContainerUtil.map(roots, psiDir -> psiDir.getVirtualFile()));
    }

    FileRecursiveIterator(@NotNull Module module) {
        this(module.getProject(), ContainerUtil.map(FileRecursiveIterator.collectModuleDirectories(module), psiDir -> psiDir.getVirtualFile()));
    }

    FileRecursiveIterator(@NotNull Project project) {
        this(project, ContainerUtil.map(FileRecursiveIterator.collectProjectDirectories(project), psiDir -> psiDir.getVirtualFile()));
    }

    FileRecursiveIterator(@NotNull PsiDirectory directory) {
        this(directory.getProject(), (Collection<? extends VirtualFile>)Collections.singletonList(directory.getVirtualFile()));
    }

    FileRecursiveIterator(@NotNull Project project, @NotNull Collection<? extends VirtualFile> roots) {
        this.myProject = project;
        this.myRoots = roots;
    }

    @NotNull
    static List<PsiDirectory> collectProjectDirectories(@NotNull Project project) {
        Module[] modules2 = ModuleManager.getInstance((Project)project).getModules();
        ArrayList<PsiDirectory> directories = new ArrayList<PsiDirectory>(modules2.length * 3);
        for (Module module : modules2) {
            directories.addAll(FileRecursiveIterator.collectModuleDirectories(module));
        }
        return directories;
    }

    boolean processAll(@NotNull Processor<? super PsiFile> processor2) {
        CompactVirtualFileSet visited = new CompactVirtualFileSet();
        for (VirtualFile virtualFile : this.myRoots) {
            if (ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().iterateContentUnderDirectory(virtualFile, fileOrDir -> {
                if (fileOrDir.isDirectory() || !visited.add(fileOrDir)) {
                    return true;
                }
                PsiFile psiFile = (PsiFile)ReadAction.compute(() -> this.myProject.isDisposed() ? null : PsiManager.getInstance((Project)this.myProject).findFile(fileOrDir));
                return psiFile == null || processor2.process((Object)psiFile);
            })) continue;
            return false;
        }
        return true;
    }

    @NotNull
    static List<PsiDirectory> collectModuleDirectories(Module module) {
        VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots();
        return (List)ReadAction.compute(() -> ContainerUtil.mapNotNull((Object[])contentRoots, root -> PsiManager.getInstance((Project)module.getProject()).findDirectory(root)));
    }
}

