/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeEditor.printing;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.impl.LineMarkersPass;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.psi.PsiFile;
import com.intellij.util.MathUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class FileSeparatorProvider {
    @NotNull
    static List<LineMarkerInfo<?>> getFileSeparators(PsiFile file2, Document document) {
        ArrayList result2 = new ArrayList();
        for (LineMarkerInfo<?> lineMarkerInfo : LineMarkersPass.queryLineMarkers(file2, document)) {
            if (lineMarkerInfo.separatorColor == null) continue;
            result2.add(lineMarkerInfo);
        }
        result2.sort(Comparator.comparingInt(i2 -> FileSeparatorProvider.getDisplayLine(i2, document)));
        return result2;
    }

    public static int getDisplayLine(@NotNull LineMarkerInfo<?> lineMarkerInfo, @NotNull Document document) {
        int offset = lineMarkerInfo.separatorPlacement == SeparatorPlacement.TOP ? lineMarkerInfo.startOffset : lineMarkerInfo.endOffset;
        return document.getLineNumber(MathUtil.clamp((int)offset, (int)0, (int)document.getTextLength())) + (lineMarkerInfo.separatorPlacement == SeparatorPlacement.TOP ? 0 : 1);
    }
}

