/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeEditor.printing;

import com.intellij.CommonBundle;
import com.intellij.codeEditor.printing.ExportToHTMLManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.io.FileNotFoundException;
import javax.swing.JOptionPane;
import org.jetbrains.annotations.NotNull;

public class ExportToHTMLAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        try {
            new ExportToHTMLManager().executeExport(dataContext);
        }
        catch (FileNotFoundException ex) {
            JOptionPane.showMessageDialog(null, EditorBundle.message((String)"file.not.found", (Object[])new Object[]{ex.getMessage()}), CommonBundle.getErrorTitle(), 0);
        }
    }

    public void update(@NotNull AnActionEvent event) {
        Presentation presentation2 = event.getPresentation();
        DataContext dataContext = event.getDataContext();
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (psiFile != null) {
            presentation2.setEnabled(psiFile.getContainingDirectory() != null);
            presentation2.setVisible(true);
        } else {
            PsiElement psiElement = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
            if (psiElement instanceof PsiDirectory) {
                presentation2.setEnabledAndVisible(true);
            }
        }
    }
}

