/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build.events.impl;

import com.intellij.build.BuildDescriptor;
import com.intellij.build.BuildViewSettingsProvider;
import com.intellij.build.DefaultBuildDescriptor;
import com.intellij.build.events.BuildEventsNls;
import com.intellij.build.events.StartBuildEvent;
import com.intellij.build.events.impl.StartEventImpl;
import com.intellij.build.process.BuildProcessHandler;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.util.Consumer;
import java.util.Arrays;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StartBuildEventImpl
extends StartEventImpl
implements StartBuildEvent {
    @NotNull
    private final DefaultBuildDescriptor myBuildDescriptor;
    @Nullable
    private BuildViewSettingsProvider myBuildViewSettingsProvider;

    public StartBuildEventImpl(@NotNull BuildDescriptor descriptor2, @NotNull @BuildEventsNls.Message String message) {
        super(descriptor2.getId(), null, descriptor2.getStartTime(), message);
        this.myBuildDescriptor = descriptor2 instanceof DefaultBuildDescriptor ? (DefaultBuildDescriptor)descriptor2 : new DefaultBuildDescriptor(descriptor2);
    }

    @ApiStatus.Experimental
    @NotNull
    public DefaultBuildDescriptor getBuildDescriptor() {
        return this.myBuildDescriptor;
    }

    @Deprecated
    public StartBuildEventImpl withProcessHandler(@Nullable BuildProcessHandler processHandler2, @Nullable Consumer<ConsoleView> attachedConsoleConsumer) {
        this.myBuildDescriptor.withProcessHandler(processHandler2, attachedConsoleConsumer);
        return this;
    }

    @Deprecated
    public StartBuildEventImpl withRestartAction(@NotNull AnAction anAction) {
        this.myBuildDescriptor.withRestartAction(anAction);
        return this;
    }

    @Deprecated
    public StartBuildEventImpl withRestartActions(AnAction ... actions) {
        Arrays.stream(actions).forEach(this.myBuildDescriptor::withRestartAction);
        return this;
    }

    @Deprecated
    public StartBuildEventImpl withContentDescriptorSupplier(Supplier<RunContentDescriptor> contentDescriptorSupplier) {
        this.myBuildDescriptor.withContentDescriptor(contentDescriptorSupplier);
        return this;
    }

    @Deprecated
    public StartBuildEventImpl withExecutionFilter(@NotNull Filter filter2) {
        this.myBuildDescriptor.withExecutionFilter(filter2);
        return this;
    }

    @Deprecated
    public StartBuildEventImpl withExecutionFilters(Filter ... filters) {
        Arrays.stream(filters).forEach(this.myBuildDescriptor::withExecutionFilter);
        return this;
    }

    @Nullable
    @ApiStatus.Experimental
    public BuildViewSettingsProvider getBuildViewSettingsProvider() {
        return this.myBuildViewSettingsProvider;
    }

    @ApiStatus.Experimental
    public StartBuildEventImpl withBuildViewSettingsProvider(@Nullable BuildViewSettingsProvider viewSettingsProvider) {
        this.myBuildViewSettingsProvider = viewSettingsProvider;
        return this;
    }
}

