/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.build.BuildConsoleUtils;
import com.intellij.build.BuildConsoleView;
import com.intellij.build.BuildDescriptor;
import com.intellij.build.BuildProgressStripe;
import com.intellij.build.BuildTextConsoleView;
import com.intellij.build.BuildTreeFilters;
import com.intellij.build.BuildViewSettingsProvider;
import com.intellij.build.BuildWorkspaceConfiguration;
import com.intellij.build.CompositeView;
import com.intellij.build.DefaultBuildDescriptor;
import com.intellij.build.ExecutionNode;
import com.intellij.build.FilePosition;
import com.intellij.build.Filterable;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.DerivedResult;
import com.intellij.build.events.DuplicateMessageAware;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.Failure;
import com.intellij.build.events.FailureResult;
import com.intellij.build.events.FileMessageEvent;
import com.intellij.build.events.FinishBuildEvent;
import com.intellij.build.events.FinishEvent;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.MessageEventResult;
import com.intellij.build.events.OutputBuildEvent;
import com.intellij.build.events.ProgressBuildEvent;
import com.intellij.build.events.StartBuildEvent;
import com.intellij.build.events.StartEvent;
import com.intellij.build.events.impl.FailureResultImpl;
import com.intellij.build.events.impl.SkippedResultImpl;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.ide.OccurenceNavigatorSupport;
import com.intellij.ide.actions.EditSourceAction;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.actions.ToggleUseSoftWrapsToolbarAction;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapAppliancePlaces;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.pom.NonNavigatable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.render.RenderingHelper;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.ui.tree.TreePathUtil;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.ui.tree.ui.DefaultTreeUI;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.EditSourceOnEnterKeyHandler;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.Invoker;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Shape;
import java.awt.event.MouseListener;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public class BuildTreeConsoleView
implements ConsoleView,
DataProvider,
BuildConsoleView,
Filterable<ExecutionNode>,
OccurenceNavigator {
    private static final Logger LOG = Logger.getInstance(BuildTreeConsoleView.class);
    @NonNls
    private static final String TREE = "tree";
    @NonNls
    private static final String SPLITTER_PROPERTY = "BuildView.Splitter.Proportion";
    private final JPanel myPanel = new JPanel();
    private final Map<Object, ExecutionNode> nodesMap = new ConcurrentHashMap<Object, ExecutionNode>();
    @NotNull
    private final Project myProject;
    @NotNull
    private final DefaultBuildDescriptor myBuildDescriptor;
    @NotNull
    private final String myWorkingDir;
    private final ConsoleViewHandler myConsoleViewHandler;
    private final AtomicBoolean myFinishedBuildEventReceived = new AtomicBoolean();
    private final AtomicBoolean myDisposed = new AtomicBoolean();
    private final AtomicBoolean myShownFirstError = new AtomicBoolean();
    private final AtomicBoolean myExpandedFirstMessage = new AtomicBoolean();
    private final boolean myNavigateToTheFirstErrorLocation;
    private final StructureTreeModel<AbstractTreeStructure> myTreeModel;
    private final Tree myTree;
    private final ExecutionNode myRootNode;
    private final ExecutionNode myBuildProgressRootNode;
    private final Set<Predicate<ExecutionNode>> myNodeFilters;
    private final ProblemOccurrenceNavigatorSupport myOccurrenceNavigatorSupport;
    private final Set<BuildEvent> myDeferredEvents = ContainerUtil.newConcurrentSet();

    public BuildTreeConsoleView(@NotNull Project project, @NotNull BuildDescriptor buildDescriptor, @Nullable ExecutionConsole executionConsole, @NotNull BuildViewSettingsProvider buildViewSettingsProvider) {
        this.myProject = project;
        this.myBuildDescriptor = buildDescriptor instanceof DefaultBuildDescriptor ? (DefaultBuildDescriptor)buildDescriptor : new DefaultBuildDescriptor(buildDescriptor);
        this.myNodeFilters = ContainerUtil.newConcurrentSet();
        this.myWorkingDir = FileUtil.toSystemIndependentName((String)buildDescriptor.getWorkingDir());
        this.myNavigateToTheFirstErrorLocation = ((BuildWorkspaceConfiguration)project.getService(BuildWorkspaceConfiguration.class)).isShowFirstErrorInEditor();
        this.myRootNode = new ExecutionNode(this.myProject, null, true, this::isCorrectThread);
        this.myBuildProgressRootNode = new ExecutionNode(this.myProject, this.myRootNode, true, this::isCorrectThread);
        this.myRootNode.setFilter(this.getFilter());
        this.myRootNode.add(this.myBuildProgressRootNode);
        MyTreeStructure treeStructure = new MyTreeStructure();
        this.myTreeModel = new StructureTreeModel<MyTreeStructure>(treeStructure, null, Invoker.forBackgroundThreadWithoutReadAction((Disposable)this), (Disposable)this);
        AsyncTreeModel asyncTreeModel = new AsyncTreeModel((TreeModel)((Object)this.myTreeModel), (Disposable)this);
        asyncTreeModel.addTreeModelListener(new ExecutionNodeAutoExpandingListener());
        this.myTree = BuildTreeConsoleView.initTree(asyncTreeModel);
        JPanel myContentPanel = new JPanel();
        myContentPanel.setLayout(new CardLayout());
        myContentPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myTree, (int)0), TREE);
        this.myPanel.setLayout(new BorderLayout());
        OnePixelSplitter myThreeComponentsSplitter = new OnePixelSplitter(SPLITTER_PROPERTY, 0.33f);
        myThreeComponentsSplitter.setFirstComponent((JComponent)myContentPanel);
        List<Filter> filters = this.myBuildDescriptor.getExecutionFilters();
        this.myConsoleViewHandler = new ConsoleViewHandler(this.myProject, this.myTree, this.myBuildProgressRootNode, (Disposable)this, executionConsole, filters, buildViewSettingsProvider);
        myThreeComponentsSplitter.setSecondComponent(this.myConsoleViewHandler.getComponent());
        this.myPanel.add((Component)myThreeComponentsSplitter, "Center");
        BuildTreeFilters.install(this);
        this.myOccurrenceNavigatorSupport = new ProblemOccurrenceNavigatorSupport(this.myTree);
    }

    private boolean isCorrectThread() {
        if (this.myTreeModel != null) {
            return this.myTreeModel.getInvoker().isValidThread();
        }
        return true;
    }

    private void installContextMenu() {
        UIUtil.invokeLaterIfNeeded(() -> {
            final DefaultActionGroup rerunActionGroup = new DefaultActionGroup();
            List<AnAction> restartActions = this.myBuildDescriptor.getRestartActions();
            rerunActionGroup.addAll(restartActions);
            if (!restartActions.isEmpty()) {
                rerunActionGroup.addSeparator();
            }
            final DefaultActionGroup sourceActionGroup = new DefaultActionGroup();
            EditSourceAction edit = new EditSourceAction();
            ActionUtil.copyFrom((AnAction)edit, (String)"EditSource");
            sourceActionGroup.add((AnAction)edit);
            final DefaultActionGroup filteringActionsGroup = BuildTreeFilters.createFilteringActionsGroup(this);
            final DefaultActionGroup navigationActionGroup = new DefaultActionGroup();
            CommonActionsManager actionsManager = CommonActionsManager.getInstance();
            AnAction prevAction = actionsManager.createPrevOccurenceAction((OccurenceNavigator)this);
            navigationActionGroup.add(prevAction);
            AnAction nextAction = actionsManager.createNextOccurenceAction((OccurenceNavigator)this);
            navigationActionGroup.add(nextAction);
            this.myTree.addMouseListener((MouseListener)new PopupHandler(){

                public void invokePopup(Component comp, int x, int y) {
                    DefaultActionGroup group = new DefaultActionGroup();
                    group.addAll((ActionGroup)rerunActionGroup);
                    group.addAll((ActionGroup)sourceActionGroup);
                    group.addSeparator();
                    ExecutionNode[] selectedNodes = BuildTreeConsoleView.this.getSelectedNodes();
                    if (selectedNodes.length == 1) {
                        ExecutionNode selectedNode = selectedNodes[0];
                        List<AnAction> contextActions = BuildTreeConsoleView.this.myBuildDescriptor.getContextActions(selectedNode);
                        if (!contextActions.isEmpty()) {
                            group.addAll(contextActions);
                            group.addSeparator();
                        }
                    }
                    group.addAll((ActionGroup)filteringActionsGroup);
                    group.addSeparator();
                    group.addAll((ActionGroup)navigationActionGroup);
                    ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("BuildView", (ActionGroup)group);
                    popupMenu.setTargetComponent((JComponent)BuildTreeConsoleView.this.myTree);
                    JPopupMenu menu = popupMenu.getComponent();
                    menu.show(comp, x, y);
                }
            });
        });
    }

    public void clear() {
        this.myTreeModel.getInvoker().runOrInvokeLater(() -> {
            this.getRootElement().removeChildren();
            this.nodesMap.clear();
            this.myConsoleViewHandler.clear();
        });
        this.scheduleUpdate(this.getRootElement(), true);
    }

    @Override
    public boolean isFilteringEnabled() {
        return true;
    }

    @Override
    @NotNull
    public Predicate<ExecutionNode> getFilter() {
        return executionNode -> executionNode == this.getBuildProgressRootNode() || executionNode.isRunning() || executionNode.isFailed() || this.myNodeFilters.stream().anyMatch(predicate -> predicate.test(executionNode));
    }

    @Override
    public void addFilter(@NotNull Predicate<ExecutionNode> executionTreeFilter) {
        this.myNodeFilters.add(executionTreeFilter);
        this.updateFilter();
    }

    @Override
    public void removeFilter(@NotNull Predicate<ExecutionNode> filter2) {
        this.myNodeFilters.remove(filter2);
        this.updateFilter();
    }

    @Override
    public boolean contains(@NotNull Predicate<ExecutionNode> filter2) {
        return this.myNodeFilters.contains(filter2);
    }

    private void updateFilter() {
        ExecutionNode rootElement = this.getRootElement();
        this.myTreeModel.getInvoker().runOrInvokeLater(() -> {
            rootElement.setFilter(this.getFilter());
            this.scheduleUpdate(rootElement, true);
        });
    }

    private ExecutionNode getRootElement() {
        return this.myRootNode;
    }

    private ExecutionNode getBuildProgressRootNode() {
        return this.myBuildProgressRootNode;
    }

    public void print(@NotNull String text, @NotNull ConsoleViewContentType contentType) {
    }

    @Nullable
    private ExecutionNode getOrMaybeCreateParentNode(@NotNull BuildEvent event) {
        ExecutionNode parentNode;
        ExecutionNode executionNode = parentNode = event.getParentId() == null ? null : this.nodesMap.get(event.getParentId());
        if (event instanceof MessageEvent && (parentNode = this.createMessageParentNodes((MessageEvent)event, parentNode)) != null) {
            this.scheduleUpdate(parentNode, true);
        }
        return parentNode;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onEventInternal(@NotNull Object buildId, @NotNull BuildEvent event) {
        boolean isMessageEvent;
        Runnable selectErrorNodeTask;
        ExecutionNode buildProgressRootNode;
        ExecutionNode currentNode;
        SmartHashSet structureChanged;
        block34: {
            Object eventId;
            block30: {
                ExecutionNode parentNode;
                block31: {
                    Navigatable messageEventNavigatable;
                    MessageEvent messageEvent;
                    block32: {
                        Iterator iterator2;
                        block33: {
                            block28: {
                                block29: {
                                    structureChanged = new SmartHashSet();
                                    parentNode = this.getOrMaybeCreateParentNode(event);
                                    eventId = event.getId();
                                    currentNode = this.nodesMap.get(eventId);
                                    buildProgressRootNode = this.getBuildProgressRootNode();
                                    selectErrorNodeTask = null;
                                    isMessageEvent = event instanceof MessageEvent;
                                    if (!(event instanceof StartEvent) && !isMessageEvent) break block28;
                                    if (currentNode != null) {
                                        LOG.warn("start event id collision found:" + eventId + ", was also in node: " + currentNode.getTitle());
                                        return;
                                    }
                                    if (event instanceof DuplicateMessageAware) {
                                        if (!this.myFinishedBuildEventReceived.get()) {
                                            this.myDeferredEvents.add(event);
                                            return;
                                        }
                                        if (parentNode != null && parentNode.findFirstChild(node -> event.getMessage().equals(node.getName())) != null) {
                                            return;
                                        }
                                    }
                                    if (!(event instanceof StartBuildEvent)) break block29;
                                    currentNode = buildProgressRootNode;
                                    this.installContextMenu();
                                    currentNode.setTitle(this.myBuildDescriptor.getTitle());
                                    break block30;
                                }
                                currentNode = new ExecutionNode(this.myProject, parentNode, false, this::isCorrectThread);
                                if (!isMessageEvent) break block31;
                                currentNode.setAlwaysLeaf(event instanceof FileMessageEvent);
                                messageEvent = (MessageEvent)event;
                                currentNode.setStartTime(messageEvent.getEventTime());
                                ContainerUtil.addIfNotNull((Collection)structureChanged, (Object)((Object)currentNode.setEndTime(messageEvent.getEventTime())));
                                messageEventNavigatable = messageEvent.getNavigatable(this.myProject);
                                currentNode.setNavigatable(messageEventNavigatable);
                                MessageEventResult messageEventResult = messageEvent.getResult();
                                ContainerUtil.addIfNotNull((Collection)structureChanged, (Object)((Object)currentNode.setResult((EventResult)messageEventResult)));
                                if (!(messageEventResult instanceof FailureResult)) break block32;
                                iterator2 = ((FailureResult)messageEventResult).getFailures().iterator();
                                break block33;
                            }
                            boolean isProgress = event instanceof ProgressBuildEvent;
                            currentNode = this.nodesMap.get(eventId);
                            if (currentNode == null) {
                                if (isProgress) {
                                    currentNode = new ExecutionNode(this.myProject, parentNode, parentNode == buildProgressRootNode, this::isCorrectThread);
                                    this.nodesMap.put(eventId, currentNode);
                                    if (parentNode != null) {
                                        structureChanged.add((Object)parentNode);
                                        parentNode.add(currentNode);
                                    }
                                } else if (event instanceof OutputBuildEvent && parentNode != null) {
                                    this.myConsoleViewHandler.addOutput(parentNode, buildId, event);
                                }
                            }
                            if (isProgress) {
                                ProgressBuildEvent progressBuildEvent = (ProgressBuildEvent)event;
                                long total = progressBuildEvent.getTotal();
                                long progress2 = progressBuildEvent.getProgress();
                                if (currentNode == this.myBuildProgressRootNode) {
                                    this.myConsoleViewHandler.updateProgressBar(total, progress2);
                                }
                            }
                            break block34;
                        }
                        while (iterator2.hasNext()) {
                            Failure failure = (Failure)iterator2.next();
                            selectErrorNodeTask = selectErrorNodeTask != null ? selectErrorNodeTask : this.showErrorIfFirst(currentNode, failure.getNavigatable());
                        }
                    }
                    if (messageEvent.getKind() == MessageEvent.Kind.ERROR) {
                        Runnable runnable2 = selectErrorNodeTask = selectErrorNodeTask != null ? selectErrorNodeTask : this.showErrorIfFirst(currentNode, messageEventNavigatable);
                    }
                    if (parentNode != null) {
                        if (parentNode != buildProgressRootNode) {
                            this.myConsoleViewHandler.addOutput(parentNode, buildId, event);
                            this.myConsoleViewHandler.addOutput(parentNode, "\n", true);
                        }
                        this.reportMessageKind(messageEvent, parentNode);
                    }
                    this.myConsoleViewHandler.addOutput(currentNode, buildId, event);
                }
                if (parentNode != null) {
                    structureChanged.add((Object)parentNode);
                    parentNode.add(currentNode);
                }
            }
            this.nodesMap.put(eventId, currentNode);
        }
        if (currentNode == null) {
            return;
        }
        currentNode.setName(event.getMessage());
        currentNode.setHint(event.getHint());
        if (currentNode.getStartTime() == 0L) {
            currentNode.setStartTime(event.getEventTime());
        }
        if (event instanceof FinishEvent) {
            EventResult result2 = ((FinishEvent)event).getResult();
            if (result2 instanceof DerivedResult) {
                result2 = BuildTreeConsoleView.calculateDerivedResult((DerivedResult)result2, currentNode);
            }
            ContainerUtil.addIfNotNull((Collection)structureChanged, (Object)((Object)currentNode.setResult(result2)));
            ContainerUtil.addIfNotNull((Collection)structureChanged, (Object)((Object)currentNode.setEndTime(event.getEventTime())));
            SkippedResultImpl skippedResult = new SkippedResultImpl();
            BuildTreeConsoleView.finishChildren((SmartHashSet<ExecutionNode>)structureChanged, currentNode, (EventResult)skippedResult);
            if (result2 instanceof FailureResult) {
                for (Failure failure : ((FailureResult)result2).getFailures()) {
                    Runnable task2 = this.addChildFailureNode(currentNode, failure, event.getMessage(), (Set<ExecutionNode>)structureChanged);
                    if (selectErrorNodeTask != null) continue;
                    selectErrorNodeTask = task2;
                }
            }
        }
        if (event instanceof FinishBuildEvent) {
            this.myFinishedBuildEventReceived.set(true);
            Object aHint = event.getHint();
            String time = DateFormatUtil.formatDateTime((long)event.getEventTime());
            aHint = aHint == null ? "at " + time : (String)aHint + " at " + time;
            currentNode.setHint((String)aHint);
            this.myDeferredEvents.forEach(buildEvent -> this.onEventInternal(buildId, (BuildEvent)buildEvent));
            if (this.myConsoleViewHandler.myExecutionNode == null) {
                this.invokeLater(() -> this.myConsoleViewHandler.setNode(buildProgressRootNode));
            }
            this.myConsoleViewHandler.stopProgressBar();
        }
        if (structureChanged.isEmpty()) {
            this.scheduleUpdate(currentNode, false);
        } else {
            for (ExecutionNode node2 : structureChanged) {
                this.scheduleUpdate(node2, true);
            }
        }
        if (selectErrorNodeTask != null) {
            this.myExpandedFirstMessage.set(true);
            Runnable finalSelectErrorTask = selectErrorNodeTask;
            this.myTreeModel.invalidate((Object)this.getRootElement(), true).onProcessed(p -> finalSelectErrorTask.run());
            return;
        }
        if (!isMessageEvent) return;
        if (!this.myExpandedFirstMessage.compareAndSet(false, true)) return;
        ExecutionNode finalCurrentNode = currentNode;
        this.myTreeModel.invalidate((Object)this.getRootElement(), false).onProcessed(p -> TreeUtil.promiseMakeVisible((JTree)this.myTree, (TreeVisitor)BuildTreeConsoleView.visitor(finalCurrentNode)));
    }

    @ApiStatus.Internal
    @Nullable
    public String getSelectedNodeConsoleText() {
        ExecutionConsole console = this.myConsoleViewHandler.getCurrentConsole();
        if (console instanceof ConsoleViewImpl) {
            ((ConsoleViewImpl)console).flushDeferredText();
            return ((ConsoleViewImpl)console).getText();
        }
        if (this.myConsoleViewHandler.myView.isViewVisible("empty")) {
            return "";
        }
        return null;
    }

    private static EventResult calculateDerivedResult(DerivedResult result2, ExecutionNode node) {
        if (node.getResult() != null) {
            return node.getResult();
        }
        if (node.isFailed()) {
            return result2.createFailureResult();
        }
        return result2.createDefaultResult();
    }

    private void reportMessageKind(@NotNull MessageEvent messageEvent, @NotNull ExecutionNode parentNode) {
        MessageEvent.Kind eventKind = messageEvent.getKind();
        if (eventKind == MessageEvent.Kind.ERROR || eventKind == MessageEvent.Kind.WARNING || eventKind == MessageEvent.Kind.INFO) {
            ExecutionNode executionNode = parentNode;
            do {
                ExecutionNode updatedRoot;
                if ((updatedRoot = executionNode.reportChildMessageKind(eventKind)) != null) {
                    this.scheduleUpdate(updatedRoot, true);
                    continue;
                }
                this.scheduleUpdate(executionNode, false);
            } while ((executionNode = executionNode.getParent()) != null);
            this.scheduleUpdate(this.getRootElement(), false);
        }
    }

    @Nullable
    private Runnable showErrorIfFirst(@NotNull ExecutionNode node, @Nullable Navigatable navigatable) {
        if (this.myShownFirstError.compareAndSet(false, true)) {
            return () -> {
                TreeUtil.promiseSelect((JTree)this.myTree, (TreeVisitor)BuildTreeConsoleView.visitor(node));
                if (this.myNavigateToTheFirstErrorLocation && navigatable != null && navigatable != NonNavigatable.INSTANCE) {
                    ApplicationManager.getApplication().invokeLater(() -> navigatable.navigate(true), ModalityState.defaultModalityState(), this.myProject.getDisposed());
                }
            };
        }
        return null;
    }

    public boolean hasNextOccurence() {
        return this.myOccurrenceNavigatorSupport.hasNextOccurence();
    }

    public boolean hasPreviousOccurence() {
        return this.myOccurrenceNavigatorSupport.hasPreviousOccurence();
    }

    public OccurenceNavigator.OccurenceInfo goNextOccurence() {
        return this.myOccurrenceNavigatorSupport.goNextOccurence();
    }

    public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
        return this.myOccurrenceNavigatorSupport.goPreviousOccurence();
    }

    @NotNull
    public String getNextOccurenceActionName() {
        return this.myOccurrenceNavigatorSupport.getNextOccurenceActionName();
    }

    @NotNull
    public String getPreviousOccurenceActionName() {
        return this.myOccurrenceNavigatorSupport.getPreviousOccurenceActionName();
    }

    @NotNull
    private static TreeVisitor visitor(@NotNull ExecutionNode executionNode) {
        TreePath treePath = TreePathUtil.pathToCustomNode(executionNode, node -> node.getParent());
        return new TreeVisitor.ByTreePath(treePath, o -> (ExecutionNode)((Object)((Object)TreeUtil.getUserObject((Object)o))));
    }

    @Nullable
    private Runnable addChildFailureNode(@NotNull ExecutionNode parentNode, @NotNull Failure failure, @NotNull String defaultFailureMessage, @NotNull Set<ExecutionNode> strcutreChanged) {
        List<Failure> failures;
        EventResult result2;
        String failureNodeName;
        ExecutionNode failureNode;
        String text = (String)ObjectUtils.chooseNotNull((Object)failure.getDescription(), (Object)failure.getMessage());
        if (text == null && failure.getError() != null) {
            text = failure.getError().getMessage();
        }
        if (text == null) {
            text = defaultFailureMessage;
        }
        if ((failureNode = parentNode.findFirstChild(arg_0 -> BuildTreeConsoleView.lambda$addChildFailureNode$14(failureNodeName = BuildConsoleUtils.getMessageTitle(text), arg_0))) == null) {
            failureNode = new ExecutionNode(this.myProject, parentNode, true, this::isCorrectThread);
            failureNode.setName(failureNodeName);
            parentNode.add(failureNode);
        }
        if (failure.getNavigatable() == null) {
            failureNode.setNavigatable(failure.getNavigatable());
        }
        if ((result2 = failureNode.getResult()) instanceof FailureResult) {
            failures = new ArrayList<Failure>(((FailureResult)result2).getFailures());
            failures.add(failure);
        } else {
            failures = Collections.singletonList(failure);
        }
        ExecutionNode updatedRoot = failureNode.setResult((EventResult)new FailureResultImpl(failures));
        if (updatedRoot == null) {
            updatedRoot = parentNode;
        }
        strcutreChanged.add(updatedRoot);
        this.myConsoleViewHandler.addOutput(failureNode, failure);
        return this.showErrorIfFirst(failureNode, failure.getNavigatable());
    }

    private static void finishChildren(@NotNull SmartHashSet<ExecutionNode> structureChanged, @NotNull ExecutionNode node, @NotNull EventResult result2) {
        List<ExecutionNode> childList = node.getChildList();
        if (childList.isEmpty()) {
            return;
        }
        for (ExecutionNode child2 : new ArrayList<ExecutionNode>(childList)) {
            if (!child2.isRunning()) continue;
            BuildTreeConsoleView.finishChildren(structureChanged, child2, result2);
            ContainerUtil.addIfNotNull(structureChanged, (Object)((Object)child2.setResult(result2)));
        }
    }

    public void scrollTo(int offset) {
    }

    public void attachToProcess(ProcessHandler processHandler2) {
    }

    public boolean isOutputPaused() {
        return false;
    }

    public void setOutputPaused(boolean value2) {
    }

    public boolean hasDeferredOutput() {
        return false;
    }

    public void performWhenNoDeferredOutput(@NotNull Runnable runnable2) {
    }

    public void setHelpId(@NotNull String helpId) {
    }

    public void addMessageFilter(@NotNull Filter filter2) {
    }

    public void printHyperlink(@NotNull String hyperlinkText, @Nullable HyperlinkInfo info) {
    }

    public int getContentSize() {
        return 0;
    }

    public boolean canPause() {
        return false;
    }

    public AnAction @NotNull [] createConsoleActions() {
        return AnAction.EMPTY_ARRAY;
    }

    public void allowHeavyFilters() {
    }

    @NotNull
    public JComponent getComponent() {
        return this.myPanel;
    }

    public JComponent getPreferredFocusableComponent() {
        return this.myTree;
    }

    public void dispose() {
        this.myDisposed.set(true);
    }

    public boolean isDisposed() {
        return this.myDisposed.get();
    }

    public void onEvent(@NotNull Object buildId, @NotNull BuildEvent event) {
        this.myTreeModel.getInvoker().invoke(() -> this.onEventInternal(buildId, event));
    }

    void scheduleUpdate(ExecutionNode executionNode, boolean parentStructureChanged) {
        ExecutionNode node = executionNode.getParent() == null || !parentStructureChanged ? executionNode : executionNode.getParent();
        this.myTreeModel.invalidate((Object)node, parentStructureChanged);
    }

    private ExecutionNode createMessageParentNodes(MessageEvent messageEvent, ExecutionNode parentNode) {
        Object messageEventParentId = messageEvent.getParentId();
        if (messageEventParentId == null) {
            return null;
        }
        if (messageEvent instanceof FileMessageEvent) {
            FilePosition filePosition = ((FileMessageEvent)messageEvent).getFilePosition();
            String filePath = FileUtil.toSystemIndependentName((String)filePosition.getFile().getPath());
            String parentsPath = "";
            String relativePath = FileUtil.getRelativePath((String)this.myWorkingDir, (String)filePath, (char)'/');
            if (relativePath != null) {
                if (relativePath.equals(".")) {
                    return parentNode;
                }
                parentsPath = this.myWorkingDir;
            }
            relativePath = StringUtil.isEmpty((String)parentsPath) ? filePath : BuildTreeConsoleView.getRelativePath(parentsPath, filePath);
            Path path = Paths.get(relativePath, new String[0]);
            String nodeName = path.getFileName().toString();
            Path pathParent = path.getParent();
            String pathHint = pathParent == null ? null : pathParent.toString();
            parentNode = this.getOrCreateMessagesNode(messageEvent, filePath, parentNode, nodeName, pathHint, () -> {
                VirtualFile file2 = VfsUtil.findFileByIoFile((File)filePosition.getFile(), (boolean)false);
                if (file2 != null) {
                    return file2.getFileType().getIcon();
                }
                return null;
            }, messageEvent.getNavigatable(this.myProject), this.nodesMap, this.myProject);
        }
        return parentNode;
    }

    private static String getRelativePath(@NotNull String basePath, @NotNull String filePath) {
        String path = (String)ObjectUtils.notNull((Object)FileUtil.getRelativePath((String)basePath, (String)filePath, (char)'/'), (Object)filePath);
        File userHomeDir = new File(SystemProperties.getUserHome());
        if (path.startsWith("..") && FileUtil.isAncestor((File)userHomeDir, (File)new File(filePath), (boolean)true)) {
            return FileUtil.getLocationRelativeToUserHome((String)filePath, (boolean)false);
        }
        return path;
    }

    public void hideRootNode() {
        UIUtil.invokeLaterIfNeeded(() -> {
            if (this.myTree != null) {
                this.myTree.setRootVisible(false);
                this.myTree.setShowsRootHandles(true);
            }
        });
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return "reference.build.tool.window";
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myProject;
        }
        if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            return this.extractSelectedNodesNavigatables();
        }
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            return this.extractSelectedNodeNavigatable();
        }
        return null;
    }

    @Nullable
    private Object extractSelectedNodeNavigatable() {
        TreePath selectedPath = TreeUtil.getSelectedPathIfOne((JTree)this.myTree);
        if (selectedPath == null) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)ObjectUtils.tryCast((Object)selectedPath.getLastPathComponent(), DefaultMutableTreeNode.class);
        if (node == null) {
            return null;
        }
        ExecutionNode executionNode = (ExecutionNode)((Object)ObjectUtils.tryCast((Object)node.getUserObject(), ExecutionNode.class));
        if (executionNode == null) {
            return null;
        }
        List<Navigatable> navigatables = executionNode.getNavigatables();
        if (navigatables.size() != 1) {
            return null;
        }
        return navigatables.get(0);
    }

    private Object extractSelectedNodesNavigatables() {
        ArrayList<Navigatable> navigatables = new ArrayList<Navigatable>();
        for (ExecutionNode each : this.getSelectedNodes()) {
            List<Navigatable> navigatable = each.getNavigatables();
            navigatables.addAll(navigatable);
        }
        return navigatables.isEmpty() ? null : navigatables.toArray(new Navigatable[0]);
    }

    private ExecutionNode[] getSelectedNodes() {
        ExecutionNode[] result2 = new ExecutionNode[]{};
        if (this.myTree != null) {
            List nodes = TreeUtil.collectSelectedObjects((JTree)this.myTree, path -> (ExecutionNode)((Object)((Object)TreeUtil.getLastUserObject(ExecutionNode.class, (TreePath)path))));
            return nodes.toArray(result2);
        }
        return result2;
    }

    @ApiStatus.Internal
    public JTree getTree() {
        return this.myTree;
    }

    private static Tree initTree(@NotNull AsyncTreeModel model) {
        Tree tree = new Tree((TreeModel)((Object)model));
        tree.setLargeModel(true);
        ComponentUtil.putClientProperty((JComponent)tree, (Key)AnimatedIcon.ANIMATION_IN_RENDERER_ALLOWED, (Object)true);
        ComponentUtil.putClientProperty((JComponent)tree, DefaultTreeUI.AUTO_EXPAND_ALLOWED, (Object)false);
        tree.setRootVisible(false);
        EditSourceOnDoubleClickHandler.install((JTree)tree);
        EditSourceOnEnterKeyHandler.install((JTree)tree);
        new TreeSpeedSearch((JTree)tree).setComparator(new SpeedSearchComparator(false));
        TreeUtil.installActions((JTree)tree);
        tree.setCellRenderer((TreeCellRenderer)((Object)new MyNodeRenderer()));
        tree.putClientProperty(RenderingHelper.SHRINK_LONG_RENDERER, (Object)true);
        return tree;
    }

    @NotNull
    private ExecutionNode getOrCreateMessagesNode(MessageEvent messageEvent, String nodeId, ExecutionNode parentNode, String nodeName, @Nullable String hint, @Nullable Supplier<? extends Icon> iconProvider, @Nullable Navigatable navigatable, Map<Object, ExecutionNode> nodesMap, Project project) {
        ExecutionNode node = nodesMap.get(nodeId);
        if (node == null) {
            node = new ExecutionNode(project, parentNode, false, this::isCorrectThread);
            node.setName(nodeName);
            if (hint != null) {
                node.setHint(hint);
            }
            node.setStartTime(messageEvent.getEventTime());
            node.setEndTime(messageEvent.getEventTime());
            if (iconProvider != null) {
                node.setIconProvider(iconProvider);
            }
            if (navigatable != null) {
                node.setNavigatable(navigatable);
            }
            parentNode.add(node);
            nodesMap.put(nodeId, node);
        }
        return node;
    }

    @ApiStatus.Internal
    public Promise<?> invokeLater(@NotNull Runnable task2) {
        return this.myTreeModel.getInvoker().invokeLater(task2);
    }

    private static /* synthetic */ boolean lambda$addChildFailureNode$14(String failureNodeName, ExecutionNode executionNode) {
        return failureNodeName.equals(executionNode.getName());
    }

    private class ExecutionNodeAutoExpandingListener
    implements TreeModelListener {
        private ExecutionNodeAutoExpandingListener() {
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            this.maybeExpand(e.getTreePath());
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
        }

        private boolean maybeExpand(TreePath path) {
            if (BuildTreeConsoleView.this.myTree == null || path == null) {
                return false;
            }
            Object last = path.getLastPathComponent();
            if (last instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode mutableTreeNode = (DefaultMutableTreeNode)last;
                boolean expanded = false;
                Enumeration<TreeNode> children2 = mutableTreeNode.children();
                if (children2.hasMoreElements()) {
                    while (children2.hasMoreElements()) {
                        TreeNode next = children2.nextElement();
                        if (next == null) continue;
                        expanded = this.maybeExpand(path.pathByAddingChild(next)) || expanded;
                    }
                    if (expanded) {
                        return true;
                    }
                    Object lastUserObject = mutableTreeNode.getUserObject();
                    if (lastUserObject instanceof ExecutionNode && ((ExecutionNode)((Object)lastUserObject)).isAutoExpandNode() && !BuildTreeConsoleView.this.myTree.isExpanded(path)) {
                        BuildTreeConsoleView.this.myTree.expandPath(path);
                        return true;
                    }
                }
            }
            return false;
        }
    }

    private class MyTreeStructure
    extends AbstractTreeStructure {
        private MyTreeStructure() {
        }

        @NotNull
        public Object getRootElement() {
            return BuildTreeConsoleView.this.myRootNode;
        }

        @NotNull
        public Object[] getChildElements(@NotNull Object element2) {
            return ((ExecutionNode)((Object)element2)).getChildList().toArray();
        }

        @Nullable
        public Object getParentElement(@NotNull Object element2) {
            return ((ExecutionNode)((Object)element2)).getParent();
        }

        @NotNull
        public NodeDescriptor createDescriptor(@NotNull Object element2, @Nullable NodeDescriptor parentDescriptor) {
            return (NodeDescriptor)element2;
        }

        public void commit() {
        }

        public boolean hasSomethingToCommit() {
            return false;
        }

        public boolean isAlwaysLeaf(@NotNull Object element2) {
            return ((ExecutionNode)((Object)element2)).isAlwaysLeaf();
        }
    }

    private static class MyNodeRenderer
    extends NodeRenderer {
        private String myDurationText;
        private Color myDurationColor;
        private int myDurationWidth;
        private int myDurationOffset;

        private MyNodeRenderer() {
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value2, boolean selected2, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.customizeCellRenderer(tree, value2, selected2, expanded, leaf, row, hasFocus);
            this.myDurationText = null;
            this.myDurationColor = null;
            this.myDurationWidth = 0;
            this.myDurationOffset = 0;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value2;
            Object userObj = node.getUserObject();
            if (userObj instanceof ExecutionNode) {
                this.myDurationText = ((ExecutionNode)((Object)userObj)).getDuration();
                if (this.myDurationText != null) {
                    FontMetrics metrics = this.getFontMetrics(RelativeFont.SMALL.derive(this.getFont()));
                    this.myDurationWidth = metrics.stringWidth(this.myDurationText);
                    this.myDurationOffset = metrics.getHeight() / 2;
                    this.myDurationColor = selected2 ? UIUtil.getTreeSelectionForeground((boolean)hasFocus) : SimpleTextAttributes.GRAYED_ATTRIBUTES.getFgColor();
                }
            }
        }

        protected void paintComponent(Graphics g) {
            UISettings.setupAntialiasing((Graphics)g);
            Shape clip = null;
            int width = this.getWidth();
            int height = this.getHeight();
            if (this.isOpaque()) {
                g.setColor(this.getBackground());
                g.fillRect(0, 0, width, height);
            }
            if (this.myDurationWidth > 0 && (width -= this.myDurationWidth + this.myDurationOffset) > 0 && height > 0) {
                g.setColor(this.myDurationColor);
                g.setFont(RelativeFont.SMALL.derive(this.getFont()));
                g.drawString(this.myDurationText, width + this.myDurationOffset / 2, MyNodeRenderer.getTextBaseLine((FontMetrics)g.getFontMetrics(), (int)height));
                clip = g.getClip();
                g.clipRect(0, 0, width, height);
            }
            super.paintComponent(g);
            if (clip != null) {
                g.setClip(clip);
            }
        }
    }

    private static class ScrollEditorToTheEndAction
    extends ToggleAction
    implements DumbAware {
        @NotNull
        private final ConsoleViewHandler myConsoleViewHandler;

        ScrollEditorToTheEndAction(@NotNull ConsoleViewHandler handler2) {
            super(ActionsBundle.message((String)"action.EditorConsoleScrollToTheEnd.text", (Object[])new Object[0]), null, AllIcons.RunConfigurations.Scroll_down);
            this.myConsoleViewHandler = handler2;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            Editor editor = this.myConsoleViewHandler.getEditor();
            if (editor == null) {
                return false;
            }
            Document document = editor.getDocument();
            return document.getLineCount() == 0 || document.getLineNumber(editor.getCaretModel().getOffset()) == document.getLineCount() - 1;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            Editor editor = this.myConsoleViewHandler.getEditor();
            if (editor == null) {
                return;
            }
            if (state) {
                EditorUtil.scrollToTheEnd(editor);
            } else {
                int lastLine = Math.max(0, editor.getDocument().getLineCount() - 1);
                LogicalPosition currentPosition = editor.getCaretModel().getLogicalPosition();
                LogicalPosition position = new LogicalPosition(Math.max(0, Math.min(currentPosition.line, lastLine - 1)), currentPosition.column);
                editor.getCaretModel().moveToLogicalPosition(position);
            }
        }
    }

    private static class ProblemOccurrenceNavigatorSupport
    extends OccurenceNavigatorSupport {
        ProblemOccurrenceNavigatorSupport(Tree tree) {
            super((JTree)tree);
        }

        protected Navigatable createDescriptorForNode(@NotNull DefaultMutableTreeNode node) {
            Object userObject = node.getUserObject();
            if (!(userObject instanceof ExecutionNode)) {
                return null;
            }
            ExecutionNode executionNode = (ExecutionNode)((Object)userObject);
            if (node.getChildCount() != 0 || !executionNode.hasWarnings() && !executionNode.isFailed()) {
                return null;
            }
            List<Navigatable> navigatables = executionNode.getNavigatables();
            if (!navigatables.isEmpty()) {
                return navigatables.get(0);
            }
            return null;
        }

        @NotNull
        public String getNextOccurenceActionName() {
            return IdeBundle.message((String)"action.next.problem", (Object[])new Object[0]);
        }

        @NotNull
        public String getPreviousOccurenceActionName() {
            return IdeBundle.message((String)"action.previous.problem", (Object[])new Object[0]);
        }
    }

    private static class ConsoleViewHandler
    implements Disposable {
        private static final String EMPTY_CONSOLE_NAME = "empty";
        private final Project myProject;
        private final JPanel myPanel;
        private final CompositeView<ExecutionConsole> myView;
        private final AtomicReference<String> myNodeConsoleViewName = new AtomicReference();
        private final Map<String, List<Consumer<BuildTextConsoleView>>> deferredNodeOutput = new ConcurrentHashMap<String, List<Consumer<BuildTextConsoleView>>>();
        @NotNull
        private final BuildViewSettingsProvider myViewSettingsProvider;
        @Nullable
        private ExecutionNode myExecutionNode;
        @NotNull
        private final List<Filter> myExecutionConsoleFilters;
        private final BuildProgressStripe myPanelWithProgress;

        ConsoleViewHandler(@NotNull Project project, @NotNull Tree tree, @NotNull ExecutionNode buildProgressRootNode, @NotNull Disposable parentDisposable, @Nullable ExecutionConsole executionConsole, @NotNull List<Filter> executionConsoleFilters, @NotNull BuildViewSettingsProvider buildViewSettingsProvider) {
            this.myProject = project;
            this.myPanel = new NonOpaquePanel((LayoutManager)new BorderLayout());
            this.myPanelWithProgress = new BuildProgressStripe(this.myPanel, parentDisposable, 300);
            this.myViewSettingsProvider = buildViewSettingsProvider;
            this.myExecutionConsoleFilters = executionConsoleFilters;
            Disposer.register((Disposable)parentDisposable, (Disposable)this);
            this.myView = new CompositeView<ExecutionConsole>(null){

                @Override
                public void addView(@NotNull ExecutionConsole view, @NotNull String viewName) {
                    super.addView(view, viewName);
                    UIUtil.removeScrollBorder((Component)view.getComponent());
                }
            };
            Disposer.register((Disposable)this, this.myView);
            if (executionConsole != null && buildViewSettingsProvider.isSideBySideView()) {
                String nodeConsoleViewName = ConsoleViewHandler.getNodeConsoleViewName(buildProgressRootNode);
                this.myView.addViewAndShowIfNeeded(executionConsole, nodeConsoleViewName, true);
                this.myNodeConsoleViewName.set(nodeConsoleViewName);
            }
            ConsoleViewImpl emptyConsole = new ConsoleViewImpl(project, GlobalSearchScope.EMPTY_SCOPE, true, false);
            this.myView.addView((ExecutionConsole)emptyConsole, EMPTY_CONSOLE_NAME);
            if (!buildViewSettingsProvider.isSideBySideView()) {
                this.myPanel.setVisible(false);
            }
            JComponent consoleComponent = emptyConsole.getComponent();
            consoleComponent.setFocusable(true);
            this.myPanel.add((Component)this.myView.getComponent(), "Center");
            DefaultActionGroup consoleActionsGroup = new DefaultActionGroup();
            consoleActionsGroup.add((AnAction)new ToggleUseSoftWrapsToolbarAction(SoftWrapAppliancePlaces.CONSOLE){

                @Override
                @Nullable
                protected Editor getEditor(@NotNull AnActionEvent e) {
                    return this.getEditor();
                }
            });
            consoleActionsGroup.add((AnAction)new ScrollEditorToTheEndAction(this));
            ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("BuildConsole", (ActionGroup)consoleActionsGroup, false);
            this.myPanel.add((Component)toolbar.getComponent(), "East");
            tree.addTreeSelectionListener(e -> {
                TreePath path = e.getPath();
                if (path == null || !e.isAddedPath()) {
                    return;
                }
                TreePath selectionPath = tree.getSelectionPath();
                this.setNode(selectionPath != null ? (DefaultMutableTreeNode)selectionPath.getLastPathComponent() : null);
            });
        }

        private void updateProgressBar(long total, long progress2) {
            this.myPanelWithProgress.updateProgress(total, progress2);
        }

        @Nullable
        private ExecutionConsole getCurrentConsole() {
            String nodeConsoleViewName = this.myNodeConsoleViewName.get();
            if (nodeConsoleViewName == null) {
                return null;
            }
            return this.myView.getView(nodeConsoleViewName);
        }

        @Nullable
        private Editor getEditor() {
            ExecutionConsole console = this.getCurrentConsole();
            if (console instanceof ConsoleViewImpl) {
                return ((ConsoleViewImpl)console).getEditor();
            }
            return null;
        }

        private boolean setNode(@NotNull ExecutionNode node) {
            String nodeConsoleViewName = ConsoleViewHandler.getNodeConsoleViewName(node);
            this.myNodeConsoleViewName.set(nodeConsoleViewName);
            ExecutionConsole view = this.myView.getView(nodeConsoleViewName);
            if (view != null) {
                List<Consumer<BuildTextConsoleView>> deferredOutput = this.deferredNodeOutput.get(nodeConsoleViewName);
                if (view instanceof BuildTextConsoleView && deferredOutput != null && !deferredOutput.isEmpty()) {
                    this.deferredNodeOutput.remove(nodeConsoleViewName);
                    deferredOutput.forEach(consumer -> consumer.accept((BuildTextConsoleView)view));
                }
                this.myView.showView(nodeConsoleViewName, false);
                this.myPanel.setVisible(true);
                return true;
            }
            List<Consumer<BuildTextConsoleView>> deferredOutput = this.deferredNodeOutput.get(nodeConsoleViewName);
            if (deferredOutput != null && !deferredOutput.isEmpty()) {
                BuildTextConsoleView textConsoleView = new BuildTextConsoleView(this.myProject, true, this.myExecutionConsoleFilters);
                this.deferredNodeOutput.remove(nodeConsoleViewName);
                deferredOutput.forEach(consumer -> consumer.accept(textConsoleView));
                this.myView.addView((ExecutionConsole)textConsoleView, nodeConsoleViewName);
                this.myView.showView(nodeConsoleViewName, false);
            } else if (this.myViewSettingsProvider.isSideBySideView()) {
                this.myView.showView(EMPTY_CONSOLE_NAME, false);
                return true;
            }
            if (!this.myViewSettingsProvider.isSideBySideView()) {
                BuildTextConsoleView taskOutputView = new BuildTextConsoleView(this.myProject, true, this.myExecutionConsoleFilters);
                EventResult eventResult = node.getResult();
                boolean hasChanged = taskOutputView.appendEventResult(eventResult);
                if (!hasChanged) {
                    return false;
                }
                taskOutputView.scrollTo(0);
                this.myView.addView((ExecutionConsole)taskOutputView, nodeConsoleViewName);
                this.myView.showView(nodeConsoleViewName, false);
                this.myPanel.setVisible(true);
            }
            return true;
        }

        private void addOutput(@NotNull ExecutionNode node, @NotNull String text, boolean stdOut) {
            this.addOutput(node, (BuildTextConsoleView view) -> view.append(text, stdOut));
        }

        private void addOutput(@NotNull ExecutionNode node, @NotNull Object buildId, BuildEvent event) {
            this.addOutput(node, (BuildTextConsoleView view) -> view.onEvent(buildId, event));
        }

        private void addOutput(@NotNull ExecutionNode node, Failure failure) {
            this.addOutput(node, (BuildTextConsoleView view) -> view.append(failure));
        }

        private void addOutput(@NotNull ExecutionNode node, Consumer<BuildTextConsoleView> consumer) {
            if (!this.myViewSettingsProvider.isSideBySideView()) {
                return;
            }
            String nodeConsoleViewName = ConsoleViewHandler.getNodeConsoleViewName(node);
            ExecutionConsole viewView = this.myView.getView(nodeConsoleViewName);
            if (viewView instanceof BuildTextConsoleView) {
                consumer.accept((BuildTextConsoleView)viewView);
            }
            if (viewView == null) {
                this.deferredNodeOutput.computeIfAbsent(nodeConsoleViewName, s -> new ArrayList()).add(consumer);
            }
        }

        public void dispose() {
            this.deferredNodeOutput.clear();
        }

        private void stopProgressBar() {
            this.myPanelWithProgress.stopLoading();
        }

        @NotNull
        private static String getNodeConsoleViewName(@NotNull ExecutionNode node) {
            return String.valueOf(System.identityHashCode((Object)node));
        }

        private void setNode(@Nullable DefaultMutableTreeNode node) {
            if (this.myProject.isDisposed()) {
                return;
            }
            if (node == null || node.getUserObject() == this.myExecutionNode) {
                return;
            }
            if (node.getUserObject() instanceof ExecutionNode) {
                this.myExecutionNode = (ExecutionNode)((Object)node.getUserObject());
                if (this.setNode((ExecutionNode)((Object)node.getUserObject()))) {
                    return;
                }
            }
            this.myExecutionNode = null;
            if (this.myView.getView("consoleView") != null) {
                this.myView.showView("consoleView", false);
                this.myPanel.setVisible(true);
            } else {
                this.myPanel.setVisible(false);
            }
        }

        public JComponent getComponent() {
            return this.myPanelWithProgress;
        }

        public void clear() {
            this.myPanel.setVisible(false);
        }
    }
}

