/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.build.BuildConsoleUtils;
import com.intellij.build.BuildConsoleView;
import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.BuildIssueEvent;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.Failure;
import com.intellij.build.events.FailureResult;
import com.intellij.build.events.FileMessageEvent;
import com.intellij.build.events.FinishEvent;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.MessageEventResult;
import com.intellij.build.events.OutputBuildEvent;
import com.intellij.execution.filters.CompositeFilter;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.LazyFileHyperlinkInfo;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ObjectUtils;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildTextConsoleView
extends ConsoleViewImpl
implements BuildConsoleView,
AnsiEscapeDecoder.ColoredTextAcceptor {
    private final AnsiEscapeDecoder myAnsiEscapeDecoder = new AnsiEscapeDecoder();

    public BuildTextConsoleView(@NotNull Project project, boolean viewer, @NotNull List<Filter> executionFilters) {
        super(project, GlobalSearchScope.allScope((Project)project), viewer, false);
        executionFilters.forEach(this::addMessageFilter);
    }

    @Override
    protected CompositeFilter createCompositeFilter() {
        CompositeFilter compositeFilter = super.createCompositeFilter();
        Project project = this.getProject();
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
        List<Filter> predefinedMessageFilters = ConsoleViewUtil.computeConsoleFilters(project, this, scope);
        predefinedMessageFilters.forEach(arg_0 -> ((CompositeFilter)compositeFilter).addFilter(arg_0));
        return compositeFilter;
    }

    public void onEvent(@NotNull Object buildId, @NotNull BuildEvent event) {
        if (event instanceof BuildIssueEvent) {
            BuildConsoleUtils.print(this, ((BuildIssueEvent)event).getGroup(), ((BuildIssueEvent)event).getIssue());
        } else if (event instanceof FileMessageEvent) {
            boolean isStdOut = ((FileMessageEvent)event).getResult().getKind() != MessageEvent.Kind.ERROR;
            String description = event.getDescription();
            if (description != null) {
                this.append(description, isStdOut);
            } else {
                FilePosition position = ((FileMessageEvent)event).getFilePosition();
                StringBuilder fileLink = new StringBuilder();
                fileLink.append(position.getFile().getName());
                if (position.getStartLine() > 0) {
                    fileLink.append(":").append(position.getStartLine() + 1);
                }
                if (position.getStartColumn() > 0) {
                    fileLink.append(":").append(position.getStartColumn() + 1);
                }
                this.print(fileLink.toString(), ConsoleViewContentType.NORMAL_OUTPUT, (HyperlinkInfo)new LazyFileHyperlinkInfo(this.getProject(), position.getFile().getPath(), position.getStartLine(), position.getStartColumn()));
                this.print(": ", ConsoleViewContentType.NORMAL_OUTPUT);
                this.append(event.getMessage(), isStdOut);
            }
        } else if (event instanceof MessageEvent) {
            this.appendEventResult((EventResult)((MessageEvent)event).getResult());
        } else if (event instanceof FinishEvent) {
            this.appendEventResult(((FinishEvent)event).getResult());
        } else if (event instanceof OutputBuildEvent) {
            this.onEvent((OutputBuildEvent)event);
        } else {
            this.append((String)ObjectUtils.chooseNotNull((Object)event.getDescription(), (Object)event.getMessage()), true);
        }
    }

    public void onEvent(@NotNull OutputBuildEvent event) {
        this.append(event.getMessage(), event.isStdOut());
    }

    public boolean appendEventResult(@Nullable EventResult eventResult) {
        if (eventResult == null) {
            return false;
        }
        boolean hasChanged = false;
        if (eventResult instanceof FailureResult) {
            List failures = ((FailureResult)eventResult).getFailures();
            if (failures.isEmpty()) {
                return false;
            }
            Iterator iterator2 = failures.iterator();
            while (iterator2.hasNext()) {
                Failure failure = (Failure)iterator2.next();
                if (this.append(failure)) {
                    hasChanged = true;
                }
                if (!iterator2.hasNext()) continue;
                this.print("\n\n", ConsoleViewContentType.NORMAL_OUTPUT);
            }
        } else if (eventResult instanceof MessageEventResult) {
            String details = ((MessageEventResult)eventResult).getDetails();
            if (details == null) {
                return false;
            }
            if (details.isEmpty()) {
                return false;
            }
            BuildConsoleUtils.printDetails(this, null, details);
            hasChanged = true;
        }
        return hasChanged;
    }

    public boolean append(@NotNull Failure failure) {
        String text = (String)ObjectUtils.chooseNotNull((Object)failure.getDescription(), (Object)failure.getMessage());
        if (text == null && failure.getError() != null) {
            text = failure.getError().getMessage();
        }
        if (text == null) {
            return false;
        }
        BuildConsoleUtils.printDetails(this, failure, text);
        return true;
    }

    public void append(@NotNull String text, boolean isStdOut) {
        Key outputType = !isStdOut ? ProcessOutputTypes.STDERR : ProcessOutputTypes.STDOUT;
        this.myAnsiEscapeDecoder.escapeText(text, outputType, (AnsiEscapeDecoder.ColoredTextAcceptor)this);
    }

    public void coloredTextAvailable(@NotNull String text, @NotNull Key attributes) {
        this.print(text, ConsoleViewContentType.getConsoleViewType((Key)attributes));
    }
}

