/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.build.AbstractViewManager;
import com.intellij.build.BuildProgressListener;
import com.intellij.build.BuildTextConsoleView;
import com.intellij.build.BuildView;
import com.intellij.build.events.Failure;
import com.intellij.build.issue.BuildIssue;
import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BuildConsoleUtils {
    private static final Logger LOG = Logger.getInstance(BuildConsoleUtils.class);
    private static final Pattern TAG_PATTERN = Pattern.compile("<[^>]*>");
    private static final Pattern A_PATTERN = Pattern.compile("<a ([^>]* )?href=[\"']([^>]*)[\"'][^>]*>");
    private static final String A_CLOSING = "</a>";
    private static final Set<String> NEW_LINES = ContainerUtil.set((Object[])new String[]{"<br>", "</br>", "<br/>", "<p>", "</p>", "<p/>", "<pre>", "</pre>"});

    public static void printDetails(@NotNull ConsoleView consoleView, @Nullable Failure failure, @Nullable String details) {
        String text;
        String string = text = failure == null ? details : (String)ObjectUtils.chooseNotNull((Object)failure.getDescription(), (Object)failure.getMessage());
        if (text == null && failure != null && failure.getError() != null) {
            text = failure.getError().getMessage();
        }
        if (text == null) {
            return;
        }
        Notification notification = failure == null ? null : failure.getNotification();
        BuildConsoleUtils.print(consoleView, notification, text);
    }

    public static void print(@NotNull BuildTextConsoleView consoleView, @NotNull String group, @NotNull BuildIssue buildIssue) {
        Project project = consoleView.getProject();
        final LinkedHashMap<String, NotificationListener> listenerMap = new LinkedHashMap<String, NotificationListener>();
        for (BuildIssueQuickFix quickFix : buildIssue.getQuickFixes()) {
            listenerMap.put(quickFix.getId(), (notification, event) -> {
                BuildView buildView = BuildConsoleUtils.findBuildView(consoleView);
                quickFix.runQuickFix(project, (DataProvider)(buildView == null ? consoleView : buildView));
            });
        }
        NotificationListener.Adapter listener2 = new NotificationListener.Adapter(){

            protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                if (event.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                    return;
                }
                NotificationListener notificationListener = (NotificationListener)listenerMap.get(event.getDescription());
                if (notificationListener != null) {
                    notificationListener.hyperlinkUpdate(notification, event);
                }
            }
        };
        Notification notification2 = new Notification(group, buildIssue.getTitle(), buildIssue.getDescription(), NotificationType.WARNING, (NotificationListener)listener2);
        BuildConsoleUtils.print((ConsoleView)consoleView, notification2, buildIssue.getDescription());
    }

    private static void print(final @NotNull ConsoleView consoleView, final @Nullable Notification notification, @NotNull String text) {
        String content2 = StringUtil.convertLineSeparators((String)text);
        while (true) {
            Matcher tagMatcher;
            if (!(tagMatcher = TAG_PATTERN.matcher(content2)).find()) break;
            String tagStart = tagMatcher.group();
            consoleView.print(content2.substring(0, tagMatcher.start()), ConsoleViewContentType.ERROR_OUTPUT);
            Matcher aMatcher = A_PATTERN.matcher(tagStart);
            if (aMatcher.matches()) {
                final String href = aMatcher.group(2);
                int linkEnd = content2.indexOf(A_CLOSING, tagMatcher.end());
                if (linkEnd > 0) {
                    String linkText = content2.substring(tagMatcher.end(), linkEnd).replaceAll(TAG_PATTERN.pattern(), "");
                    consoleView.printHyperlink(linkText, new HyperlinkInfo(){

                        public void navigate(Project project) {
                            if (notification != null && notification.getListener() != null) {
                                notification.getListener().hyperlinkUpdate(notification, IJSwingUtilities.createHyperlinkEvent(href, consoleView.getComponent()));
                            }
                        }
                    });
                    content2 = content2.substring(linkEnd + A_CLOSING.length());
                    continue;
                }
            }
            if (NEW_LINES.contains(tagStart)) {
                consoleView.print("\n", ConsoleViewContentType.SYSTEM_OUTPUT);
            } else {
                consoleView.print(content2.substring(tagMatcher.start(), tagMatcher.end()), ConsoleViewContentType.ERROR_OUTPUT);
            }
            content2 = content2.substring(tagMatcher.end());
        }
        consoleView.print(content2, ConsoleViewContentType.ERROR_OUTPUT);
        consoleView.print("\n", ConsoleViewContentType.SYSTEM_OUTPUT);
    }

    @ApiStatus.Internal
    @NotNull
    public static String getMessageTitle(@NotNull String message) {
        int sepIndex = (message = StringUtil.stripHtml((String)message, (boolean)true)).indexOf(". ");
        if (sepIndex < 0) {
            sepIndex = message.indexOf("\n");
        }
        if (sepIndex > 0) {
            message = message.substring(0, sepIndex);
        }
        return StringUtil.trimEnd((String)message, (char)'.');
    }

    @ApiStatus.Experimental
    @NotNull
    public static DataProvider getDataProvider(@NotNull Object buildId, @NotNull AbstractViewManager buildListener) {
        BuildView buildView = buildListener.getBuildView(buildId);
        return buildView != null ? buildView : dataId -> null;
    }

    @ApiStatus.Experimental
    @NotNull
    public static DataProvider getDataProvider(@NotNull Object buildId, @NotNull BuildProgressListener buildListener) {
        BuildView provider;
        if (buildListener instanceof BuildView) {
            provider = (BuildView)buildListener;
        } else if (buildListener instanceof AbstractViewManager) {
            provider = BuildConsoleUtils.getDataProvider(buildId, (AbstractViewManager)buildListener);
        } else {
            LOG.error("BuildView or AbstractViewManager expected to obtain proper DataProvider for build console quick fixes");
            provider = dataId -> null;
        }
        return provider;
    }

    @Nullable
    private static BuildView findBuildView(@NotNull Component component2) {
        Component parent = component2;
        while ((parent = parent.getParent()) != null) {
            if (!(parent instanceof BuildView)) continue;
            return (BuildView)parent;
        }
        return null;
    }
}

