/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.schemes;

import com.intellij.application.options.schemes.AbstractSchemesPanel;
import com.intellij.application.options.schemes.SchemesCombo;
import com.intellij.application.options.schemes.SchemesModel;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.scale.JBUIScale;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Collection;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditableSchemesCombo<T extends Scheme> {
    public static final String EMPTY_NAME_MESSAGE = "The name must not be empty";
    public static final String NAME_ALREADY_EXISTS_MESSAGE = "Name is already in use. Please change to unique name.";
    public static final String EDITING_HINT = "Enter to save, Esc to cancel";
    public static final int COMBO_WIDTH = 200;
    private SchemesCombo<T> myComboBox;
    private final JPanel myRootPanel;
    private final AbstractSchemesPanel<T, ?> mySchemesPanel;
    private final CardLayout myLayout;
    private final JTextField myNameEditorField;
    @Nullable
    private NameEditData myNameEditData;
    private static final KeyStroke ESC_KEY_STROKE = KeyStroke.getKeyStroke(27, 0, false);
    private static final KeyStroke ENTER_KEY_STROKE = KeyStroke.getKeyStroke(10, 0, false);
    private static final Color MODIFIED_ITEM_FOREGROUND = JBColor.namedColor((String)"ComboBox.modifiedItemForeground", (Color)JBColor.BLUE);

    public EditableSchemesCombo(@NotNull AbstractSchemesPanel<T, ?> schemesPanel) {
        this.mySchemesPanel = schemesPanel;
        this.myLayout = new CardLayout();
        this.myRootPanel = new JPanel(this.myLayout);
        this.createCombo();
        this.myRootPanel.add((Component)((Object)this.myComboBox));
        this.myNameEditorField = this.createNameEditorField();
        this.myRootPanel.add(this.myNameEditorField);
        this.myRootPanel.setPreferredSize(new Dimension(JBUIScale.scale((int)200), this.myNameEditorField.getPreferredSize().height));
        this.myRootPanel.setMaximumSize(new Dimension(JBUIScale.scale((int)200), Short.MAX_VALUE));
    }

    private JTextField createNameEditorField() {
        JTextField nameEditorField = new JTextField();
        nameEditorField.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditableSchemesCombo.this.revertSchemeName();
                EditableSchemesCombo.this.cancelEdit();
            }
        }, ESC_KEY_STROKE, 0);
        nameEditorField.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditableSchemesCombo.this.stopEdit();
            }
        }, ENTER_KEY_STROKE, 0);
        nameEditorField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                EditableSchemesCombo.this.stopEdit();
            }
        });
        nameEditorField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                EditableSchemesCombo.this.validateOnTyping();
            }
        });
        return nameEditorField;
    }

    private void validateOnTyping() {
        String validationMessage;
        if (this.myNameEditData == null) {
            return;
        }
        String currName = this.myNameEditorField.getText();
        if (!currName.equals(this.myNameEditData.initialName) && (validationMessage = this.validateSchemeName(currName, this.myNameEditData.isProjectScheme)) != null) {
            this.mySchemesPanel.showInfo(validationMessage, MessageType.ERROR);
            return;
        }
        this.showHint();
    }

    private void showHint() {
        this.mySchemesPanel.showInfo(EDITING_HINT, MessageType.INFO);
    }

    private void revertSchemeName() {
        if (this.myNameEditData != null) {
            this.myNameEditorField.setText(this.myNameEditData.initialName);
        }
    }

    public void updateSelected() {
        this.myComboBox.repaint();
    }

    private void stopEdit() {
        if (this.myNameEditData == null) {
            this.cancelEdit();
            return;
        }
        String newName = this.myNameEditorField.getText();
        String validationMessage = this.validateSchemeName(newName, this.myNameEditData.isProjectScheme);
        if (validationMessage != null) {
            this.mySchemesPanel.showInfo(validationMessage, MessageType.ERROR);
        } else {
            this.myNameEditData.nameConsumer.accept(newName);
            this.cancelEdit();
        }
    }

    public void cancelEdit() {
        this.mySchemesPanel.clearInfo();
        this.myLayout.first(this.myRootPanel);
        this.myNameEditData = null;
        IdeFocusManager focusManager = IdeFocusManager.getGlobalInstance();
        focusManager.doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myRootPanel, true));
    }

    private void createCombo() {
        this.myComboBox = new SchemesCombo<T>(){

            @Override
            protected boolean supportsProjectSchemes() {
                return EditableSchemesCombo.this.mySchemesPanel.supportsProjectSchemes();
            }

            @Override
            protected boolean isProjectScheme(@NotNull T scheme) {
                return EditableSchemesCombo.this.mySchemesPanel.getModel().isProjectScheme(scheme);
            }

            @Override
            protected int getIndent(@NotNull T scheme) {
                return EditableSchemesCombo.this.mySchemesPanel.getIndent(scheme);
            }

            @Override
            @NotNull
            protected SimpleTextAttributes getSchemeAttributes(T scheme) {
                SimpleTextAttributes baseAttributes;
                SchemesModel model = EditableSchemesCombo.this.mySchemesPanel.getModel();
                SimpleTextAttributes simpleTextAttributes = baseAttributes = !EditableSchemesCombo.this.useBoldForNonRemovableSchemes() || model.canDeleteScheme(scheme) ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
                if (EditableSchemesCombo.this.mySchemesPanel.highlightNonDefaultSchemes() && model.canResetScheme(scheme) && model.differsFromDefault(scheme)) {
                    return baseAttributes.derive(-1, MODIFIED_ITEM_FOREGROUND, null, null);
                }
                return baseAttributes;
            }
        };
        this.myComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditableSchemesCombo.this.mySchemesPanel.getActions().onSchemeChanged(EditableSchemesCombo.this.getSelectedScheme());
            }
        });
    }

    public void startEdit(@NotNull String initialName, boolean isProjectScheme, @NotNull Consumer<? super String> nameConsumer) {
        this.showHint();
        this.myNameEditData = new NameEditData(initialName, nameConsumer, isProjectScheme);
        this.myNameEditorField.setText(initialName);
        this.myLayout.last(this.myRootPanel);
        SwingUtilities.invokeLater(() -> {
            IdeFocusManager focusManager = IdeFocusManager.getGlobalInstance();
            focusManager.doWhenFocusSettlesDown(() -> focusManager.requestFocus((Component)this.myNameEditorField, true));
        });
    }

    public void resetSchemes(@NotNull Collection<? extends T> schemes) {
        this.myComboBox.resetSchemes(schemes);
    }

    @Nullable
    public T getSelectedScheme() {
        return this.myComboBox.getSelectedScheme();
    }

    public void selectScheme(@Nullable T scheme) {
        this.myComboBox.selectScheme(scheme);
    }

    public JComponent getComponent() {
        return this.myRootPanel;
    }

    private boolean useBoldForNonRemovableSchemes() {
        return this.mySchemesPanel.useBoldForNonRemovableSchemes();
    }

    @Nullable
    private String validateSchemeName(@NotNull String name, boolean isProjectScheme) {
        if (this.myNameEditData != null && name.equals(this.myNameEditData.initialName)) {
            return null;
        }
        if (StringUtil.isEmptyOrSpaces((String)name)) {
            return EMPTY_NAME_MESSAGE;
        }
        if (this.mySchemesPanel.getModel().containsScheme(name, isProjectScheme)) {
            return NAME_ALREADY_EXISTS_MESSAGE;
        }
        return null;
    }

    private static class NameEditData {
        @NotNull
        private final String initialName;
        @NotNull
        private final Consumer<? super String> nameConsumer;
        private final boolean isProjectScheme;

        private NameEditData(@NotNull String name, @NotNull Consumer<? super String> nameConsumer, boolean isProjectScheme) {
            this.initialName = name;
            this.nameConsumer = nameConsumer;
            this.isProjectScheme = isProjectScheme;
        }
    }
}

