/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.schemes;

import com.intellij.application.options.schemes.AbstractSchemeActions;
import com.intellij.application.options.schemes.EditableSchemesCombo;
import com.intellij.application.options.schemes.SchemeNameGenerator;
import com.intellij.application.options.schemes.SchemesModel;
import com.intellij.icons.AllIcons;
import com.intellij.ide.HelpTooltip;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionButtonComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSchemesPanel<T extends Scheme, InfoComponent extends JComponent>
extends JPanel {
    private EditableSchemesCombo<T> mySchemesCombo;
    private AbstractSchemeActions<T> myActions;
    private JComponent myToolbar;
    InfoComponent myInfoComponent;
    private static final Color HINT_FOREGROUND = JBColor.GRAY;
    private static final Color ERROR_MESSAGE_FOREGROUND = Color.RED;
    protected static final int DEFAULT_VGAP = 8;
    private JSeparator mySettingsPanelSeparator;

    AbstractSchemesPanel() {
        this(8);
    }

    AbstractSchemesPanel(int vGap) {
        this.setLayout(new BoxLayout(this, 3));
        this.createUIComponents(vGap);
    }

    private void createUIComponents(int vGap) {
        JComponent bottomComponent;
        JPanel controlsPanel = this.createControlsPanel();
        this.add(controlsPanel);
        JComponent topComponent = this.createTopComponent();
        if (topComponent != null) {
            this.add(topComponent);
        }
        if ((bottomComponent = this.createBottomComponent()) != null) {
            this.add(bottomComponent);
        }
        this.mySettingsPanelSeparator = new JSeparator();
        this.add(this.mySettingsPanelSeparator);
        if (vGap > 0) {
            this.add(Box.createVerticalGlue());
            this.add(Box.createRigidArea((Dimension)new JBDimension(0, vGap)));
        }
    }

    public void setSeparatorVisible(boolean visible) {
        this.mySettingsPanelSeparator.setVisible(visible);
    }

    protected JComponent createTopComponent() {
        return null;
    }

    @Nullable
    protected JComponent createBottomComponent() {
        return null;
    }

    @NotNull
    private JPanel createControlsPanel() {
        JPanel controlsPanel = new JPanel();
        controlsPanel.setLayout(new BoxLayout(controlsPanel, 2));
        String label2 = this.getComboBoxLabel();
        if (label2 != null) {
            controlsPanel.add(new JLabel(label2));
            controlsPanel.add(Box.createRigidArea((Dimension)new JBDimension(10, 0)));
        }
        this.myActions = this.createSchemeActions();
        this.mySchemesCombo = new EditableSchemesCombo(this);
        controlsPanel.add(this.mySchemesCombo.getComponent());
        this.myToolbar = this.createToolbar();
        controlsPanel.add(Box.createRigidArea((Dimension)new JBDimension(4, 0)));
        controlsPanel.add(this.myToolbar);
        controlsPanel.add(Box.createRigidArea((Dimension)new JBDimension(9, 0)));
        this.myInfoComponent = this.createInfoComponent();
        controlsPanel.add((Component)this.myInfoComponent);
        controlsPanel.add(Box.createHorizontalGlue());
        this.mySchemesCombo.getComponent().setMaximumSize(this.mySchemesCombo.getComponent().getPreferredSize());
        int height = this.mySchemesCombo.getComponent().getPreferredSize().height;
        controlsPanel.setMaximumSize(new Dimension(controlsPanel.getMaximumSize().width, height));
        return controlsPanel;
    }

    @NotNull
    private JComponent createToolbar() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new ShowSchemesActionsListAction(this.myActions));
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("NavBarToolbar", (ActionGroup)group, true);
        toolbar.setReservePlaceAutoPopupIcon(false);
        toolbar.setLayoutPolicy(0);
        JComponent toolbarComponent = toolbar.getComponent();
        Dimension maxSize2 = toolbarComponent.getMaximumSize();
        toolbarComponent.setMaximumSize((Dimension)JBUI.size((int)22, (int)maxSize2.height));
        toolbarComponent.setBorder(JBUI.Borders.empty((int)3));
        return toolbarComponent;
    }

    public final JComponent getToolbar() {
        return this.myToolbar;
    }

    @NotNull
    protected abstract AbstractSchemeActions<T> createSchemeActions();

    public final T getSelectedScheme() {
        return this.mySchemesCombo.getSelectedScheme();
    }

    public void selectScheme(@Nullable T scheme) {
        this.mySchemesCombo.selectScheme(scheme);
    }

    public final void resetSchemes(@NotNull Collection<? extends T> schemes) {
        this.mySchemesCombo.resetSchemes(schemes);
    }

    public void disposeUIResources() {
        this.removeAll();
    }

    final void editCurrentSchemeName(@NotNull BiConsumer<? super T, ? super String> newSchemeNameConsumer) {
        Object currentScheme = this.getSelectedScheme();
        if (currentScheme != null) {
            String currentName = currentScheme.getName();
            this.mySchemesCombo.startEdit(currentName, this.getModel().isProjectScheme(currentScheme), newName -> {
                if (!newName.equals(currentName)) {
                    newSchemeNameConsumer.accept((Object)currentScheme, (String)newName);
                }
            });
        }
    }

    public final void editNewSchemeName(@NotNull String preferredName, boolean isProjectScheme, @NotNull Consumer<? super String> nameConsumer) {
        String name = SchemeNameGenerator.getUniqueName(preferredName, schemeName -> this.getModel().containsScheme((String)schemeName, isProjectScheme));
        this.mySchemesCombo.startEdit(name, isProjectScheme, nameConsumer);
    }

    public final void cancelEdit() {
        this.mySchemesCombo.cancelEdit();
    }

    public final void showInfo(@NotNull String message, @NotNull MessageType messageType) {
        this.myToolbar.setVisible(false);
        this.showMessage(message, messageType);
    }

    protected abstract void showMessage(@Nullable String var1, @NotNull MessageType var2);

    final void clearInfo() {
        this.myToolbar.setVisible(true);
        this.clearMessage();
    }

    protected abstract void clearMessage();

    @NotNull
    public final AbstractSchemeActions<T> getActions() {
        return this.myActions;
    }

    @NotNull
    protected abstract InfoComponent createInfoComponent();

    @Nullable
    protected String getComboBoxLabel() {
        return this.getSchemeTypeName() + ":";
    }

    @NotNull
    protected String getSchemeTypeName() {
        return ApplicationBundle.message((String)"editbox.scheme.type.name", (Object[])new Object[0]);
    }

    @NotNull
    public abstract SchemesModel<T> getModel();

    public final void updateOnCurrentSettingsChange() {
        this.mySchemesCombo.updateSelected();
    }

    protected int getIndent(@NotNull T scheme) {
        return 0;
    }

    protected abstract boolean supportsProjectSchemes();

    protected abstract boolean highlightNonDefaultSchemes();

    protected boolean hideDeleteActionIfUnavailable() {
        return true;
    }

    public abstract boolean useBoldForNonRemovableSchemes();

    public void showStatus(@NotNull String message, @NotNull MessageType messageType) {
        BalloonBuilder balloonBuilder = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message, messageType.getDefaultIcon(), messageType.getPopupBackground(), null);
        balloonBuilder.setFadeoutTime(5000L);
        Balloon balloon = balloonBuilder.createBalloon();
        Point pointOnComponent = new Point(this.myToolbar.getWidth() / 4, this.myToolbar.getHeight() / 4);
        balloon.show(new RelativePoint((Component)this.myToolbar, pointOnComponent), Balloon.Position.above);
        Disposer.register((Disposable)ProjectManager.getInstance().getDefaultProject(), (Disposable)balloon);
    }

    protected static void showMessage(@Nullable String message, @NotNull MessageType messageType, @NotNull JLabel infoComponent) {
        infoComponent.setText(message);
        Color foreground = messageType == MessageType.INFO ? HINT_FOREGROUND : (messageType == MessageType.ERROR ? ERROR_MESSAGE_FOREGROUND : messageType.getTitleForeground());
        infoComponent.setForeground(foreground);
    }

    private static class ShowSchemesActionsListAction
    extends DefaultActionGroup {
        private final AbstractSchemeActions<?> mySchemeActions;

        ShowSchemesActionsListAction(AbstractSchemeActions<?> schemeActions) {
            this.setPopup(true);
            this.mySchemeActions = schemeActions;
            this.getTemplatePresentation().setIcon(AllIcons.General.GearPlain);
            this.getTemplatePresentation().setText(IdeBundle.messagePointer((String)"action.presentation.AbstractSchemesPanel.text", (Object[])new Object[0]));
            this.getTemplatePresentation().setDescription(IdeBundle.messagePointer((String)"action.presentation.AbstractSchemesPanel.description", (Object[])new Object[0]));
        }

        public boolean isDumbAware() {
            return true;
        }

        public boolean canBePerformed(@NotNull DataContext context) {
            return true;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DefaultActionGroup group = new DefaultActionGroup();
            group.addAll(this.mySchemeActions.getActions());
            ListPopup popup2 = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)group, e.getDataContext(), true, null, Integer.MAX_VALUE);
            HelpTooltip.setMasterPopup((Component)e.getInputEvent().getComponent(), (JBPopup)popup2);
            Component component2 = e.getInputEvent().getComponent();
            if (component2 instanceof ActionButtonComponent) {
                popup2.showUnderneathOf(component2);
            } else {
                popup2.showInCenterOf(component2);
            }
        }
    }
}

