/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors.highlighting;

import com.intellij.application.options.colors.highlighting.HighlightData;
import com.intellij.application.options.colors.highlighting.RendererWrapper;
import com.intellij.codeInsight.daemon.impl.HintRenderer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InlineElementData
extends HighlightData {
    private final String myText;
    private final boolean myAddBorder;

    public InlineElementData(int offset, TextAttributesKey attributesKey, String text, ColorKey additionalColorKey) {
        this(offset, attributesKey, text, false, additionalColorKey);
    }

    private InlineElementData(int offset, TextAttributesKey attributesKey, String text, boolean highlighted, ColorKey additionalColorKey) {
        super(offset, offset, attributesKey, additionalColorKey);
        this.myText = text;
        this.myAddBorder = highlighted;
    }

    public String getText() {
        return this.myText;
    }

    @Override
    public void addHighlToView(Editor view, EditorColorsScheme scheme, Map<TextAttributesKey, String> displayText) {
        int offset = this.getStartOffset();
        RendererWrapper renderer = new RendererWrapper(new HintRenderer(this.myText){

            @Override
            @Nullable
            protected TextAttributes getTextAttributes(@NotNull Editor editor) {
                return editor.getColorsScheme().getAttributes(InlineElementData.this.getHighlightKey());
            }
        }, this.myAddBorder);
        view.getInlayModel().addInlineElement(offset, false, (EditorCustomElementRenderer)renderer);
    }

    @Override
    public void addToCollection(@NotNull Collection<? super HighlightData> list2, boolean highlighted) {
        list2.add(new InlineElementData(this.getStartOffset(), this.getHighlightKey(), this.myText, highlighted, this.getAdditionalColorKey()));
    }
}

