/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.colors.InspectionColorSettingsPage;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeveritiesProvider;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.openapi.options.colors.ColorAndFontDescriptorsProvider;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class ColorSettingsUtil {
    private ColorSettingsUtil() {
    }

    public static Map<TextAttributesKey, String> keyToDisplayTextMap(ColorSettingsPage page) {
        List<AttributesDescriptor> attributeDescriptors = ColorSettingsUtil.getAllAttributeDescriptors((ColorAndFontDescriptorsProvider)page);
        HashMap<TextAttributesKey, String> displayText = new HashMap<TextAttributesKey, String>();
        for (AttributesDescriptor attributeDescriptor : attributeDescriptors) {
            TextAttributesKey key = attributeDescriptor.getKey();
            displayText.put(key, attributeDescriptor.getDisplayName());
        }
        return displayText;
    }

    public static List<AttributesDescriptor> getAllAttributeDescriptors(@NotNull ColorAndFontDescriptorsProvider provider) {
        ArrayList<AttributesDescriptor> result2 = new ArrayList<AttributesDescriptor>();
        Collections.addAll(result2, provider.getAttributeDescriptors());
        if (ColorSettingsUtil.isInspectionColorsPage(provider)) {
            ColorSettingsUtil.addInspectionSeverityAttributes(result2);
        }
        return result2;
    }

    private static boolean isInspectionColorsPage(ColorAndFontDescriptorsProvider provider) {
        ColorSettingsPage settingsPage;
        if (!(provider instanceof InspectionColorSettingsPage)) {
            return false;
        }
        Iterator iterator2 = ColorSettingsPage.EP_NAME.getExtensionList().iterator();
        while (iterator2.hasNext() && (settingsPage = (ColorSettingsPage)iterator2.next()) != provider) {
            if (!(settingsPage instanceof InspectionColorSettingsPage)) continue;
            return false;
        }
        return true;
    }

    private static void addInspectionSeverityAttributes(List<? super AttributesDescriptor> descriptors) {
        descriptors.add((AttributesDescriptor)new AttributesDescriptor(OptionsBundle.message((String)"options.java.attribute.descriptor.unknown.symbol", (Object[])new Object[0]), CodeInsightColors.WRONG_REFERENCES_ATTRIBUTES));
        descriptors.add((AttributesDescriptor)new AttributesDescriptor(OptionsBundle.message((String)"options.java.attribute.descriptor.deprecated.symbol", (Object[])new Object[0]), CodeInsightColors.DEPRECATED_ATTRIBUTES));
        descriptors.add((AttributesDescriptor)new AttributesDescriptor(OptionsBundle.message((String)"options.java.attribute.descriptor.marked.for.removal.symbol", (Object[])new Object[0]), CodeInsightColors.MARKED_FOR_REMOVAL_ATTRIBUTES));
        descriptors.add((AttributesDescriptor)new AttributesDescriptor(OptionsBundle.message((String)"options.java.attribute.descriptor.unused.symbol", (Object[])new Object[0]), CodeInsightColors.NOT_USED_ELEMENT_ATTRIBUTES));
        descriptors.add((AttributesDescriptor)new AttributesDescriptor(OptionsBundle.message((String)"options.java.attribute.descriptor.error", (Object[])new Object[0]), CodeInsightColors.ERRORS_ATTRIBUTES));
        descriptors.add((AttributesDescriptor)new AttributesDescriptor(OptionsBundle.message((String)"options.java.attribute.descriptor.warning", (Object[])new Object[0]), CodeInsightColors.WARNINGS_ATTRIBUTES));
        descriptors.add((AttributesDescriptor)new AttributesDescriptor(OptionsBundle.message((String)"options.java.attribute.descriptor.weak.warning", (Object[])new Object[0]), CodeInsightColors.WEAK_WARNING_ATTRIBUTES));
        descriptors.add((AttributesDescriptor)new AttributesDescriptor(OptionsBundle.message((String)"options.java.attribute.descriptor.server.problems", (Object[])new Object[0]), CodeInsightColors.GENERIC_SERVER_ERROR_OR_WARNING));
        descriptors.add((AttributesDescriptor)new AttributesDescriptor(OptionsBundle.message((String)"options.java.attribute.descriptor.server.duplicate", (Object[])new Object[0]), CodeInsightColors.DUPLICATE_FROM_SERVER));
        descriptors.add((AttributesDescriptor)new AttributesDescriptor(OptionsBundle.message((String)"options.java.attribute.descriptor.runtime", (Object[])new Object[0]), CodeInsightColors.RUNTIME_ERROR));
        for (SeveritiesProvider provider : SeveritiesProvider.EP_NAME.getExtensionList()) {
            for (HighlightInfoType highlightInfoType : provider.getSeveritiesHighlightInfoTypes()) {
                TextAttributesKey attributesKey = highlightInfoType.getAttributesKey();
                descriptors.add((AttributesDescriptor)new AttributesDescriptor(ColorSettingsUtil.toDisplayName(attributesKey), attributesKey));
            }
        }
    }

    @NotNull
    private static String toDisplayName(@NotNull TextAttributesKey attributesKey) {
        return OptionsBundle.message((String)"options.java.attribute.descriptor.errors.group", (Object[])new Object[]{StringUtil.capitalize((String)StringUtil.toLowerCase((String)attributesKey.getExternalName()).replaceAll("_", " "))});
    }
}

