/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.arrangement.match;

import com.intellij.application.options.codeStyle.arrangement.ArrangementConstants;
import com.intellij.application.options.codeStyle.arrangement.ui.ArrangementEditorAware;
import com.intellij.openapi.diagnostic.Logger;
import javax.swing.table.DefaultTableModel;
import org.jetbrains.annotations.NotNull;

public class ArrangementMatchingRulesModel
extends DefaultTableModel {
    private static final Logger LOG = Logger.getInstance(ArrangementMatchingRulesModel.class);

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return Object.class;
    }

    public Object getElementAt(int row) {
        return this.getValueAt(row, 0);
    }

    public void set(int row, Object value2) {
        this.setValueAt(value2, row, 0);
    }

    public void insert(int row, Object value2) {
        this.insertRow(row, new Object[]{value2});
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        if (ArrangementConstants.LOG_RULE_MODIFICATION) {
            LOG.info(String.format("Setting match rule '%s' to index %d", aValue, row));
        }
        super.setValueAt(aValue, row, column);
    }

    public void add(@NotNull Object data2) {
        this.addRow(new Object[]{data2});
    }

    @Override
    public void addRow(Object[] rowData) {
        if (ArrangementConstants.LOG_RULE_MODIFICATION) {
            LOG.info(String.format("Adding match rule '%s' (to index %d)", rowData[0], this.getRowCount()));
        }
        super.addRow(rowData);
    }

    @Override
    public void removeRow(int row) {
        if (ArrangementConstants.LOG_RULE_MODIFICATION) {
            LOG.info(String.format("Removing match rule '%s' from index %d", this.getValueAt(row, 0), row));
        }
        super.removeRow(row);
    }

    public void clear() {
        this.getDataVector().removeAllElements();
    }

    public int getSize() {
        return this.getRowCount();
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return this.getValueAt(row, column) instanceof ArrangementEditorAware;
    }
}

