/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.arrangement;

import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.application.options.codeStyle.arrangement.additional.ForceArrangementPanel;
import com.intellij.application.options.codeStyle.arrangement.color.ArrangementColorsProvider;
import com.intellij.application.options.codeStyle.arrangement.color.ArrangementColorsProviderImpl;
import com.intellij.application.options.codeStyle.arrangement.group.ArrangementGroupingRulesPanel;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementMatchingRulesPanel;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.Rearranger;
import com.intellij.psi.codeStyle.arrangement.group.ArrangementGroupingRule;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementSectionRule;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementColorsAware;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementStandardSettingsAware;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementStandardSettingsManager;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementExtendableSettings;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementRuleAliasToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementSettings;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.GridBag;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrangementSettingsPanel
extends CodeStyleAbstractPanel {
    @NotNull
    private final JPanel myContent = new JPanel(new GridBagLayout());
    @NotNull
    private final Language myLanguage;
    @NotNull
    private final ArrangementStandardSettingsAware mySettingsAware;
    @NotNull
    private final ArrangementGroupingRulesPanel myGroupingRulesPanel;
    @NotNull
    private final ArrangementMatchingRulesPanel myMatchingRulesPanel;
    @Nullable
    private final ForceArrangementPanel myForceArrangementPanel;

    public ArrangementSettingsPanel(@NotNull CodeStyleSettings settings, @NotNull Language language) {
        super(settings);
        this.myLanguage = language;
        Rearranger rearranger = (Rearranger)Rearranger.EXTENSION.forLanguage(language);
        if (!(rearranger instanceof ArrangementStandardSettingsAware)) {
            throw new IllegalArgumentException("Incorrect rearranger for " + language.getID() + " language: " + rearranger);
        }
        this.mySettingsAware = (ArrangementStandardSettingsAware)rearranger;
        ArrangementColorsProviderImpl colorsProvider = rearranger instanceof ArrangementColorsAware ? new ArrangementColorsProviderImpl((ArrangementColorsAware)rearranger) : new ArrangementColorsProviderImpl(null);
        ArrangementStandardSettingsManager settingsManager = new ArrangementStandardSettingsManager(this.mySettingsAware, (ArrangementColorsProvider)colorsProvider);
        this.myGroupingRulesPanel = new ArrangementGroupingRulesPanel(settingsManager, colorsProvider);
        this.myMatchingRulesPanel = new ArrangementMatchingRulesPanel(this.myLanguage, settingsManager, colorsProvider);
        this.myContent.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        this.myContent.add((Component)this.myGroupingRulesPanel, new GridBag().coverLine().fillCellHorizontally().weightx(1.0));
        this.myContent.add((Component)this.myMatchingRulesPanel, new GridBag().fillCell().weightx(1.0).weighty(1.0).coverLine());
        if (settings.getCommonSettings(this.myLanguage).isForceArrangeMenuAvailable()) {
            this.myForceArrangementPanel = new ForceArrangementPanel();
            this.myForceArrangementPanel.setSelectedMode(settings.getCommonSettings((Language)language).FORCE_REARRANGE_MODE);
            this.myContent.add((Component)this.myForceArrangementPanel.getPanel(), new GridBag().anchor(17).coverLine().fillCellHorizontally());
        } else {
            this.myForceArrangementPanel = null;
        }
        List groupingTokens = settingsManager.getSupportedGroupingTokens();
        this.myGroupingRulesPanel.setVisible(groupingTokens != null && !groupingTokens.isEmpty());
    }

    @Override
    @Nullable
    public JComponent getPanel() {
        return this.myContent;
    }

    @Override
    @Nullable
    protected EditorHighlighter createHighlighter(EditorColorsScheme scheme) {
        return null;
    }

    @Nullable
    private StdArrangementSettings getSettings(@NotNull CodeStyleSettings settings) {
        StdArrangementSettings result2 = (StdArrangementSettings)settings.getCommonSettings(this.myLanguage).getArrangementSettings();
        if (result2 == null) {
            result2 = this.mySettingsAware.getDefaultSettings();
        }
        return result2;
    }

    @Override
    public void apply(CodeStyleSettings settings) {
        CommonCodeStyleSettings commonSettings = settings.getCommonSettings(this.myLanguage);
        commonSettings.setArrangementSettings((ArrangementSettings)this.createSettings());
        if (this.myForceArrangementPanel != null) {
            commonSettings.FORCE_REARRANGE_MODE = this.myForceArrangementPanel.getRearrangeMode();
        }
    }

    @Override
    public boolean isModified(CodeStyleSettings settings) {
        StdArrangementSettings s = this.createSettings();
        return !Comparing.equal((Object)this.getSettings(settings), (Object)s) || this.myForceArrangementPanel != null && settings.getCommonSettings((Language)this.myLanguage).FORCE_REARRANGE_MODE != this.myForceArrangementPanel.getRearrangeMode();
    }

    private StdArrangementSettings createSettings() {
        List<ArrangementGroupingRule> groupingRules = this.myGroupingRulesPanel.getRules();
        List<ArrangementSectionRule> sections = this.myMatchingRulesPanel.getSections();
        Collection<StdArrangementRuleAliasToken> tokens = this.myMatchingRulesPanel.getRulesAliases();
        if (tokens != null) {
            return new StdArrangementExtendableSettings(groupingRules, sections, tokens);
        }
        return new StdArrangementSettings(groupingRules, sections);
    }

    @Override
    protected void resetImpl(CodeStyleSettings settings) {
        StdArrangementSettings s = this.getSettings(settings);
        if (s == null) {
            this.myGroupingRulesPanel.setRules(null);
            this.myMatchingRulesPanel.setSections(null);
        } else {
            List groupings = s.getGroupings();
            this.myGroupingRulesPanel.setRules(new ArrayList(groupings));
            this.myMatchingRulesPanel.setSections(ArrangementSettingsPanel.copy(s.getSections()));
            if (s instanceof StdArrangementExtendableSettings) {
                this.myMatchingRulesPanel.setRulesAliases(((StdArrangementExtendableSettings)s).getRuleAliases());
            }
            if (this.myForceArrangementPanel != null) {
                this.myForceArrangementPanel.setSelectedMode(settings.getCommonSettings((Language)this.myLanguage).FORCE_REARRANGE_MODE);
            }
        }
    }

    @NotNull
    private static List<ArrangementSectionRule> copy(@NotNull List<? extends ArrangementSectionRule> rules) {
        ArrayList<ArrangementSectionRule> result2 = new ArrayList<ArrangementSectionRule>();
        for (ArrangementSectionRule arrangementSectionRule : rules) {
            result2.add(arrangementSectionRule.clone());
        }
        return result2;
    }

    @Override
    protected String getTabTitle() {
        return ApplicationBundle.message((String)"arrangement.title.settings.tab", (Object[])new Object[0]);
    }

    @Override
    @Nullable
    protected String getPreviewText() {
        return null;
    }

    @Override
    protected int getRightMargin() {
        Logger.getInstance(ArrangementSettingsPanel.class).error("This method should not be called because getPreviewText() returns null");
        return 0;
    }

    @Override
    @NotNull
    protected FileType getFileType() {
        Logger.getInstance(ArrangementSettingsPanel.class).error("This method should not be called because getPreviewText() returns null");
        return (FileType)ObjectUtils.notNull((Object)this.myLanguage.getAssociatedFileType(), (Object)FileTypes.UNKNOWN);
    }
}

