/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle;

import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.fields.valueEditors.CommaSeparatedIntegersValueEditor;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

final class MarginOptionsUtil {
    MarginOptionsUtil() {
    }

    public static String getDefaultRightMarginText(@NotNull CodeStyleSettings settings) {
        return MarginOptionsUtil.getDefaultValueText(Integer.toString(settings.getDefaultRightMargin()));
    }

    static String getDefaultVisualGuidesText(@NotNull CodeStyleSettings settings) {
        List softMargins = settings.getDefaultSoftMargins();
        return MarginOptionsUtil.getDefaultValueText(softMargins.size() > 0 ? CommaSeparatedIntegersValueEditor.intListToString((List)settings.getDefaultSoftMargins()) : ApplicationBundle.message((String)"settings.soft.margins.empty.list", (Object[])new Object[0]));
    }

    static String getDefaultWrapOnTypingText(@NotNull CodeStyleSettings settings) {
        return MarginOptionsUtil.getDefaultValueText(settings.WRAP_WHEN_TYPING_REACHES_RIGHT_MARGIN ? "Yes" : "No");
    }

    static void customizeWrapOnTypingCombo(@NotNull JComboBox<String> wrapOnTypingCombo, @NotNull CodeStyleSettings settings) {
        wrapOnTypingCombo.setRenderer((ListCellRenderer<String>)SimpleListCellRenderer.create((String)"", value2 -> {
            for (int i2 = 0; i2 < CodeStyleSettingsCustomizable.WRAP_ON_TYPING_VALUES.length; ++i2) {
                if (CodeStyleSettingsCustomizable.WRAP_ON_TYPING_VALUES[i2] != CommonCodeStyleSettings.WrapOnTyping.DEFAULT.intValue || !CodeStyleSettingsCustomizable.WRAP_ON_TYPING_OPTIONS[i2].equals(value2)) continue;
                return MarginOptionsUtil.getDefaultWrapOnTypingText(settings);
            }
            return value2;
        }));
    }

    static String getDefaultValueText(@NotNull String value2) {
        return ApplicationBundle.message((String)"settings.default.value.prefix", (Object[])new Object[]{value2});
    }
}

