/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.problemsView.toolWindow;

import com.intellij.analysis.problemsView.toolWindow.Node;
import com.intellij.analysis.problemsView.toolWindow.Root;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.tree.BaseTreeModel;
import com.intellij.util.concurrency.Invoker;
import com.intellij.util.concurrency.InvokerSupplier;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProblemsTreeModel
extends BaseTreeModel<Node>
implements InvokerSupplier {
    private final Invoker invoker = Invoker.forBackgroundThreadWithReadAction((Disposable)this);
    private final AtomicReference<Root> root = new AtomicReference();
    private final AtomicReference<Comparator<Node>> comparator = new AtomicReference();

    public ProblemsTreeModel(@NotNull Disposable parent) {
        Disposer.register((Disposable)parent, (Disposable)this);
    }

    public void dispose() {
        super.dispose();
        this.setRoot(null);
    }

    @Override
    @NotNull
    public Invoker getInvoker() {
        return this.invoker;
    }

    public Root getRoot() {
        Root root = this.root.get();
        if (root != null && this.invoker.isValidThread()) {
            root.update();
        }
        return root;
    }

    @Override
    @NotNull
    public List<? extends Node> getChildren(Object object) {
        Collection<Node> children2;
        assert (this.invoker.isValidThread()) : "unexpected thread";
        Node node = object instanceof Node ? (Node)((Object)object) : null;
        Collection<Node> collection = children2 = node == null ? null : node.getChildren();
        if (children2 == null || children2.isEmpty()) {
            return Collections.emptyList();
        }
        assert (null != this.comparator.get()) : "set comparator before";
        node.update();
        children2.forEach(PresentableNodeDescriptor::update);
        return children2.stream().sorted(this.comparator.get()).collect(Collectors.toList());
    }

    void setComparator(@NotNull Comparator<Node> comparator2) {
        if (!comparator2.equals(this.comparator.getAndSet(comparator2))) {
            this.structureChanged();
        }
    }

    boolean isRoot(@NotNull Root root) {
        return root == this.root.get();
    }

    void setRoot(@Nullable Root root) {
        Root old = this.root.getAndSet(root);
        if (old != root && old != null) {
            Disposer.dispose((Disposable)old);
        }
        this.structureChanged();
    }

    void structureChanged() {
        this.treeStructureChanged(null, null, null);
    }

    void structureChanged(@NotNull Node node) {
        this.treeStructureChanged(node.getPath(), null, null);
    }

    void nodeChanged(@NotNull Node node) {
        this.treeNodesChanged(node.getPath(), null, null);
    }
}

