/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.model;

import com.intellij.execution.CantRunException;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.testframework.SourceScope;
import com.intellij.execution.testframework.TestSearchScope;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.theoryinpractice.testng.configuration.TestNGConfiguration;
import com.theoryinpractice.testng.model.TestClassFilter;
import com.theoryinpractice.testng.model.TestData;
import com.theoryinpractice.testng.model.TestNGTestObject;
import com.theoryinpractice.testng.util.TestNGUtil;
import java.util.List;
import java.util.Map;

public class TestNGTestPackage
extends TestNGTestObject {
    public TestNGTestPackage(TestNGConfiguration configuration) {
        super(configuration);
    }

    @Override
    public void fillTestObjects(Map<PsiClass, Map<PsiMethod, List<String>>> classes) throws CantRunException {
        String packageName = this.myConfig.getPersistantData().getPackageName();
        PsiPackage psiPackage = (PsiPackage)ReadAction.compute(() -> JavaPsiFacade.getInstance((Project)this.myConfig.getProject()).findPackage(packageName));
        if (psiPackage == null) {
            throw CantRunException.packageNotFound((String)packageName);
        }
        TestSearchScope scope = this.myConfig.getPersistantData().getScope();
        SourceScope sourceScope = scope.getSourceScope((ModuleBasedConfiguration)this.myConfig);
        TestClassFilter projectFilter = new TestClassFilter(sourceScope != null ? sourceScope.getGlobalSearchScope() : GlobalSearchScope.projectScope((Project)this.myConfig.getProject()), this.myConfig.getProject(), true, true);
        TestClassFilter filter = projectFilter.intersectionWith(PackageScope.packageScope((PsiPackage)psiPackage, (boolean)true));
        TestNGTestPackage.calculateDependencies(null, classes, this.getSearchScope(), TestNGUtil.getAllTestClasses(filter, false));
        if (classes.size() == 0) {
            throw new CantRunException("No tests found in the package \"" + packageName + '\"');
        }
    }

    @Override
    public String getGeneratedName() {
        String packageName = this.myConfig.getPersistantData().getPackageName();
        return packageName.length() == 0 ? "<default>" : packageName;
    }

    @Override
    public String getActionName() {
        String s = this.myConfig.getName();
        if (!this.myConfig.isGeneratedName()) {
            return '\"' + s + '\"';
        }
        if (this.myConfig.getPersistantData().getPackageName().trim().length() > 0) {
            return "Tests in \"" + this.myConfig.getPersistantData().getPackageName() + '\"';
        }
        return "All Tests";
    }

    @Override
    public void checkConfiguration() throws RuntimeConfigurationException {
        TestData data = this.myConfig.getPersistantData();
        PsiPackage psiPackage = JavaPsiFacade.getInstance((Project)this.myConfig.getProject()).findPackage(data.getPackageName());
        if (psiPackage == null) {
            throw new RuntimeConfigurationException("Package '" + data.getPackageName() + "' not found");
        }
    }

    @Override
    public boolean isConfiguredByElement(PsiElement element) {
        String packageName = this.myConfig.getPersistantData().getPackageName();
        if (element instanceof PsiPackage) {
            return Comparing.strEqual((String)packageName, (String)((PsiPackage)element).getQualifiedName());
        }
        if (element instanceof PsiDirectory) {
            PsiPackage psiPackage = JavaDirectoryService.getInstance().getPackage((PsiDirectory)element);
            return psiPackage != null && Comparing.strEqual((String)packageName, (String)psiPackage.getQualifiedName());
        }
        return false;
    }
}

