/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.configuration;

import com.intellij.execution.JavaTestConfigurationBase;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.testframework.AbstractInClassConfigurationProducer;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.theoryinpractice.testng.configuration.TestNGConfiguration;
import com.theoryinpractice.testng.configuration.TestNGConfigurationProducer;
import com.theoryinpractice.testng.configuration.TestNGConfigurationType;
import com.theoryinpractice.testng.model.TestType;
import org.jetbrains.annotations.NotNull;

public class TestNGInClassConfigurationProducer
extends TestNGConfigurationProducer {
    private final TestNGInClassConfigurationProducerDelegate myDelegate = new TestNGInClassConfigurationProducerDelegate();

    public void onFirstRun(@NotNull ConfigurationFromContext configuration, @NotNull ConfigurationContext fromContext, @NotNull Runnable performRunnable) {
        this.myDelegate.onFirstRun(configuration, fromContext, performRunnable);
    }

    protected boolean setupConfigurationFromContext(@NotNull TestNGConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        return this.myDelegate.setupConfigurationFromContext(configuration, context, sourceElement);
    }

    protected boolean isApplicableTestType(String type, ConfigurationContext context) {
        return this.myDelegate.isApplicableTestType(type, context);
    }

    private static class TestNGInClassConfigurationProducerDelegate
    extends AbstractInClassConfigurationProducer<TestNGConfiguration> {
        private TestNGInClassConfigurationProducerDelegate() {
        }

        @NotNull
        public ConfigurationFactory getConfigurationFactory() {
            return TestNGConfigurationType.getInstance();
        }

        protected boolean setupConfigurationFromContext(@NotNull TestNGConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
            return super.setupConfigurationFromContext((JavaTestConfigurationBase)configuration, context, sourceElement);
        }

        protected boolean isApplicableTestType(String type, ConfigurationContext context) {
            return TestType.CLASS.getType().equals(type) || TestType.METHOD.getType().equals(type);
        }
    }
}

