/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.branchConfig.SelectBranchPopup;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationNew;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.integrate.IntegratedSelectedOptionsDialog;
import org.jetbrains.idea.svn.integrate.MergerFactory;
import org.jetbrains.idea.svn.integrate.SvnIntegrateChangesTask;
import org.jetbrains.idea.svn.integrate.WorkingCopyInfo;

public class SvnIntegrateChangesActionPerformer
implements SelectBranchPopup.BranchSelectedCallback {
    private final SvnVcs myVcs;
    @NotNull
    private final MergerFactory myMergerFactory;
    private final Url myCurrentBranch;

    public SvnIntegrateChangesActionPerformer(Project project, Url currentBranchUrl, @NotNull MergerFactory mergerFactory) {
        this.myVcs = SvnVcs.getInstance(project);
        this.myCurrentBranch = currentBranchUrl;
        this.myMergerFactory = mergerFactory;
    }

    @Override
    public void branchSelected(Project project, SvnBranchConfigurationNew configuration, @NotNull Url url, long revision) {
        this.onBranchSelected(url, null, null);
    }

    public void onBranchSelected(@NotNull Url url, @Nullable String selectedLocalBranchPath, @Nullable String dialogTitle) {
        if (this.myCurrentBranch.equals(url)) {
            SvnIntegrateChangesActionPerformer.showSameSourceAndTargetMessage();
        } else {
            Pair<WorkingCopyInfo, Url> pair = this.selectWorkingCopy(url, selectedLocalBranchPath, dialogTitle);
            if (pair != null) {
                this.runIntegrate(url, (WorkingCopyInfo)pair.first, (Url)pair.second);
            }
        }
    }

    @Nullable
    private Pair<WorkingCopyInfo, Url> selectWorkingCopy(@NotNull Url url, @Nullable String selectedLocalBranchPath, @Nullable String dialogTitle) {
        return IntegratedSelectedOptionsDialog.selectWorkingCopy(this.myVcs.getProject(), this.myCurrentBranch, url, true, selectedLocalBranchPath, dialogTitle);
    }

    private void runIntegrate(@NotNull Url url, @NotNull WorkingCopyInfo workingCopy, @NotNull Url workingCopyUrl) {
        Url sourceUrl = this.correctSourceUrl(url, workingCopyUrl);
        if (sourceUrl != null) {
            SvnIntegrateChangesTask integrateTask = new SvnIntegrateChangesTask(this.myVcs, workingCopy, this.myMergerFactory, sourceUrl, SvnBundle.message("action.Subversion.integrate.changes.messages.title", new Object[0]), this.myVcs.getSvnConfiguration().isMergeDryRun(), this.myCurrentBranch.getTail());
            integrateTask.queue();
        }
    }

    @Nullable
    private Url correctSourceUrl(@NotNull Url targetUrl, @NotNull Url realTargetUrl) {
        if (SvnUtil.isAncestor(targetUrl, realTargetUrl)) {
            try {
                return this.myCurrentBranch.appendPath(SvnUtil.getRelativeUrl(targetUrl, realTargetUrl), false);
            }
            catch (SvnBindException svnBindException) {
                // empty catch block
            }
        }
        return null;
    }

    private static void showSameSourceAndTargetMessage() {
        Messages.showErrorDialog((String)SvnBundle.message("action.Subversion.integrate.changes.error.source.and.target.same.text", new Object[0]), (String)SvnBundle.message("action.Subversion.integrate.changes.messages.title", new Object[0]));
    }
}

