/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.ContentRevisionCache;
import com.intellij.vcsUtil.VcsUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnRevisionNumber;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.checkin.CommitInfo;
import org.jetbrains.idea.svn.history.LogEntry;
import org.jetbrains.idea.svn.history.SvnRepositoryLocation;

public class SvnFileRevision
implements VcsFileRevision {
    private static final Logger LOG = Logger.getInstance(SvnFileRevision.class);
    private final Date myDate;
    private String myCommitMessage;
    private final String myAuthor;
    @NotNull
    private final SvnRevisionNumber myRevisionNumber;
    @NotNull
    private final SvnVcs myVCS;
    @NotNull
    private final Url myURL;
    private final Revision myPegRevision;
    private final String myCopyFromPath;
    @NotNull
    private final List<SvnFileRevision> myMergeSources = new ArrayList<SvnFileRevision>();

    @Deprecated
    public SvnFileRevision(@NotNull SvnVcs vcs, Revision pegRevision, @NotNull Revision revision, @NotNull String url, String author, Date date, String commitMessage, String copyFromPath) {
        this(vcs, pegRevision, revision, SvnUtil.parseUrl(url, false), author, date, commitMessage, copyFromPath);
    }

    public SvnFileRevision(@NotNull SvnVcs vcs, Revision pegRevision, @NotNull Revision revision, @NotNull Url url, String author, Date date, String commitMessage, String copyFromPath) {
        this.myRevisionNumber = new SvnRevisionNumber(revision);
        this.myPegRevision = pegRevision;
        this.myAuthor = author;
        this.myDate = date;
        this.myCommitMessage = commitMessage;
        this.myCopyFromPath = copyFromPath;
        this.myVCS = vcs;
        this.myURL = url;
    }

    public SvnFileRevision(@NotNull SvnVcs vcs, Revision pegRevision, LogEntry logEntry, @NotNull Url url, String copyFromPath) {
        this.myRevisionNumber = new SvnRevisionNumber(Revision.of(logEntry.getRevision()));
        this.myPegRevision = pegRevision;
        this.myAuthor = logEntry.getAuthor();
        this.myDate = logEntry.getDate();
        this.myCommitMessage = logEntry.getMessage();
        this.myCopyFromPath = copyFromPath;
        this.myVCS = vcs;
        this.myURL = url;
    }

    @NotNull
    public CommitInfo getCommitInfo() {
        return new CommitInfo.Builder(this.myRevisionNumber.getRevision().getNumber(), this.myDate, this.myAuthor).build();
    }

    @NotNull
    public Url getURL() {
        return this.myURL;
    }

    public Revision getPegRevision() {
        return this.myPegRevision;
    }

    @NotNull
    public SvnRevisionNumber getRevisionNumber() {
        return this.myRevisionNumber;
    }

    public String getBranchName() {
        return null;
    }

    @Nullable
    public SvnRepositoryLocation getChangedRepositoryPath() {
        return new SvnRepositoryLocation(this.myURL);
    }

    public Date getRevisionDate() {
        return this.myDate;
    }

    public String getAuthor() {
        return this.myAuthor;
    }

    public String getCommitMessage() {
        return this.myCommitMessage;
    }

    public void addMergeSource(@NotNull SvnFileRevision source) {
        this.myMergeSources.add(source);
    }

    @NotNull
    public List<SvnFileRevision> getMergeSources() {
        return this.myMergeSources;
    }

    private byte[] loadRevisionContent() throws VcsException {
        ContentLoader loader = new ContentLoader();
        if (ApplicationManager.getApplication().isDispatchThread() && !this.getRevision().isLocal()) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously((Runnable)loader, SvnBundle.message("progress.title.loading.file.content", new Object[0]), false, this.myVCS.getProject());
        } else {
            loader.run();
        }
        VcsException exception = loader.getException();
        if (exception == null) {
            byte[] contents = loader.getContents();
            ContentRevisionCache.checkContentsSize((String)this.myURL.toDecodedString(), (long)contents.length);
            return contents;
        }
        LOG.info("Failed to load file '" + this.myURL.toDecodedString() + "' content at revision: " + this.getRevision() + "\n" + exception.getMessage(), (Throwable)exception);
        throw exception;
    }

    public byte @NotNull [] loadContent() throws IOException, VcsException {
        byte[] result = Revision.HEAD.equals(this.getRevision()) ? this.loadRevisionContent() : ContentRevisionCache.getOrLoadAsBytes((Project)this.myVCS.getProject(), (FilePath)VcsUtil.getFilePathOnNonLocal((String)this.myURL.toDecodedString(), (boolean)false), (VcsRevisionNumber)this.getRevisionNumber(), (VcsKey)this.myVCS.getKeyInstanceMethod(), (ContentRevisionCache.UniqueType)ContentRevisionCache.UniqueType.REMOTE_CONTENT, () -> this.loadRevisionContent());
        return result;
    }

    public byte[] getContent() throws IOException, VcsException {
        return this.loadContent();
    }

    public String getCopyFromPath() {
        return this.myCopyFromPath;
    }

    public void setCommitMessage(String message) {
        this.myCommitMessage = message;
    }

    @NotNull
    public Revision getRevision() {
        return this.myRevisionNumber.getRevision();
    }

    private class ContentLoader
    implements Runnable {
        private VcsException myException;
        private byte[] myContents;

        private ContentLoader() {
        }

        public VcsException getException() {
            return this.myException;
        }

        private byte[] getContents() {
            return this.myContents;
        }

        @Override
        public void run() {
            ProgressManager.progress((String)SvnBundle.message("progress.text.loading.contents", SvnFileRevision.this.myURL.toDecodedString()), (String)SvnBundle.message("progress.text2.revision.information", SvnFileRevision.this.getRevision()));
            try {
                this.myContents = SvnUtil.getFileContents(SvnFileRevision.this.myVCS, Target.on(SvnFileRevision.this.myURL), SvnFileRevision.this.getRevision(), SvnFileRevision.this.myPegRevision);
            }
            catch (VcsException e) {
                this.myException = e;
            }
        }
    }
}

