/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.api.BaseNodeDescription;
import org.jetbrains.idea.svn.api.NodeKind;
import org.jetbrains.idea.svn.commandLine.CommandUtil;

public class LogEntryPath
extends BaseNodeDescription {
    private final String myPath;
    private final char myType;
    private final String myCopyPath;
    private final long myCopyRevision;

    public LogEntryPath(@NotNull Builder builder) {
        super(builder.kind);
        this.myPath = builder.path;
        this.myType = CommandUtil.getStatusChar(builder.action);
        this.myCopyPath = builder.copyFromPath;
        this.myCopyRevision = builder.copyFromRevision;
    }

    public String getCopyPath() {
        return this.myCopyPath;
    }

    public long getCopyRevision() {
        return this.myCopyRevision;
    }

    public String getPath() {
        return this.myPath;
    }

    public char getType() {
        return this.myType;
    }

    @XmlAccessorType(value=XmlAccessType.NONE)
    @XmlType(name="logentrypath")
    public static class Builder {
        @XmlAttribute(name="kind", required=true)
        private NodeKind kind;
        @XmlAttribute(name="action")
        private String action;
        @XmlAttribute(name="copyfrom-path")
        private String copyFromPath;
        @XmlAttribute(name="copyfrom-rev")
        private long copyFromRevision;
        @XmlValue
        private String path;

        public String getPath() {
            return this.path;
        }

        @NotNull
        public Builder setKind(@NotNull NodeKind kind) {
            this.kind = kind;
            return this;
        }

        @NotNull
        public Builder setType(char type) {
            this.action = String.valueOf(type);
            return this;
        }

        @NotNull
        public Builder setCopyFromPath(String copyFromPath) {
            this.copyFromPath = copyFromPath;
            return this;
        }

        @NotNull
        public Builder setCopyFromRevision(long copyFromRevision) {
            this.copyFromRevision = copyFromRevision;
            return this;
        }

        @NotNull
        public Builder setPath(String path) {
            this.path = path;
            return this;
        }

        @NotNull
        public LogEntryPath build() {
            return new LogEntryPath(this);
        }
    }
}

