/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs.browser;

import com.intellij.util.NotNullFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.dialogs.RepositoryBrowserComponent;
import org.jetbrains.idea.svn.dialogs.browser.AbstractOpeningExpander;
import org.jetbrains.idea.svn.dialogs.browserCache.Expander;

public class UrlOpeningExpander
extends AbstractOpeningExpander {
    @NotNull
    private final Url myUrl;

    UrlOpeningExpander(@NotNull RepositoryBrowserComponent browser, @NotNull Url selectionPath, @NotNull Url url) {
        super(browser, selectionPath);
        this.myUrl = url;
    }

    @Override
    protected AbstractOpeningExpander.ExpandVariants expandNode(@NotNull Url url) {
        if (this.myUrl.equals(url)) {
            return AbstractOpeningExpander.ExpandVariants.EXPAND_AND_EXIT;
        }
        if (SvnUtil.isAncestor(url, this.myUrl)) {
            return AbstractOpeningExpander.ExpandVariants.EXPAND_CONTINUE;
        }
        return AbstractOpeningExpander.ExpandVariants.DO_NOTHING;
    }

    @Override
    protected boolean checkChild(@NotNull Url childUrl) {
        return SvnUtil.isAncestor(childUrl, this.myUrl);
    }

    public static class Factory
    implements NotNullFunction<RepositoryBrowserComponent, Expander> {
        @NotNull
        private final Url myUrl;

        public Factory(@NotNull Url url) {
            this.myUrl = url;
        }

        @NotNull
        public Expander fun(RepositoryBrowserComponent repositoryBrowserComponent) {
            return new UrlOpeningExpander(repositoryBrowserComponent, this.myUrl, this.myUrl);
        }
    }
}

