/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import java.io.File;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.api.EventAction;
import org.jetbrains.idea.svn.api.ProgressEvent;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.status.StatusType;

public class UpdateOutputLineConverter {
    private static final String MERGING = "--- Merging";
    private static final String RECORDING_MERGE_INFO = "--- Recording mergeinfo";
    private static final String UPDATING = "Updating";
    private static final String SKIPPED = "Skipped";
    private static final String RESTORED = "Restored";
    private static final String FETCHING_EXTERNAL = "Fetching external";
    private static final Pattern ourAtRevision = Pattern.compile("At revision (\\d+)\\.");
    private static final Pattern ourUpdatedToRevision = Pattern.compile("Updated to revision (\\d+)\\.");
    private static final Pattern ourCheckedOutRevision = Pattern.compile("Checked out revision (\\d+)\\.");
    private static final Pattern ourExportedRevision = Pattern.compile("Exported revision (\\d+)\\.");
    private static final Pattern ourExportComplete = Pattern.compile("Export complete\\.");
    private static final Pattern ourExternal = Pattern.compile("External at revision (\\d+)\\.");
    private static final Pattern ourUpdatedExternal = Pattern.compile("Updated external to revision (\\d+)\\.");
    private static final Pattern ourCheckedOutExternal = Pattern.compile("Checked out external at revision (\\d+)\\.");
    private static final Pattern[] ourCompletePatterns = new Pattern[]{ourAtRevision, ourUpdatedToRevision, ourCheckedOutRevision, ourExportedRevision, ourExternal, ourUpdatedExternal, ourCheckedOutExternal, ourExportComplete};
    private final File myBase;
    @NotNull
    private final Stack<File> myRootsUnderProcessing;
    private static final Set<Character> ourActions = ContainerUtil.set((Object[])new Character[]{Character.valueOf('A'), Character.valueOf('D'), Character.valueOf('U'), Character.valueOf('C'), Character.valueOf('G'), Character.valueOf('E'), Character.valueOf('R')});

    public UpdateOutputLineConverter(File base) {
        this.myBase = base;
        this.myRootsUnderProcessing = new Stack();
    }

    @Nullable
    public ProgressEvent convert(String line) {
        if (StringUtil.isEmptyOrSpaces((String)line)) {
            return null;
        }
        if (line.startsWith(MERGING) || line.startsWith(RECORDING_MERGE_INFO)) {
            return null;
        }
        if (line.startsWith(UPDATING)) {
            this.myRootsUnderProcessing.push((Object)this.parseForPath(line));
            return UpdateOutputLineConverter.createEvent((File)this.myRootsUnderProcessing.peek(), EventAction.UPDATE_NONE);
        }
        if (line.startsWith(RESTORED)) {
            return UpdateOutputLineConverter.createEvent(this.parseForPath(line), EventAction.RESTORE);
        }
        if (line.startsWith(SKIPPED)) {
            return UpdateOutputLineConverter.createEvent(this.parseForPath(line), -1L, EventAction.SKIP, UpdateOutputLineConverter.parseComment(line));
        }
        if (line.startsWith(FETCHING_EXTERNAL)) {
            this.myRootsUnderProcessing.push((Object)this.parseForPath(line));
            return UpdateOutputLineConverter.createEvent((File)this.myRootsUnderProcessing.peek(), EventAction.UPDATE_EXTERNAL);
        }
        for (Pattern pattern : ourCompletePatterns) {
            long revision = UpdateOutputLineConverter.matchAndGetRevision(pattern, line);
            if (revision == -1L) continue;
            File currentRoot = this.myRootsUnderProcessing.size() > 0 ? (File)this.myRootsUnderProcessing.pop() : this.myBase;
            return UpdateOutputLineConverter.createEvent(currentRoot, revision, EventAction.UPDATE_COMPLETED, null);
        }
        return this.parseNormalString(line);
    }

    @NotNull
    private static ProgressEvent createEvent(File file, @NotNull EventAction action) {
        return UpdateOutputLineConverter.createEvent(file, -1L, action, null);
    }

    @NotNull
    private static ProgressEvent createEvent(File file, long revision, @NotNull EventAction action, @Nullable String error) {
        return new ProgressEvent(file, revision, null, null, action, error, null);
    }

    @Nullable
    private ProgressEvent parseNormalString(String line) {
        if (line.length() < 5) {
            return null;
        }
        char first = line.charAt(0);
        if (' ' != first && !ourActions.contains(Character.valueOf(first))) {
            return null;
        }
        StatusType contentsStatus = CommandUtil.getStatusType(first);
        char second = line.charAt(1);
        StatusType propertiesStatus = CommandUtil.getStatusType(second);
        char lock = line.charAt(2);
        if (' ' != lock && 'B' != lock) {
            return null;
        }
        char treeConflict = line.charAt(3);
        if (' ' != treeConflict && 'C' != treeConflict) {
            return null;
        }
        boolean haveTreeConflict = 'C' == treeConflict;
        String path = line.substring(4).trim();
        if (StringUtil.isEmptyOrSpaces((String)path)) {
            return null;
        }
        File file = SvnUtil.resolvePath(this.myBase, path);
        if (StatusType.STATUS_OBSTRUCTED.equals((Object)contentsStatus)) {
            return new ProgressEvent(file, -1L, contentsStatus, propertiesStatus, EventAction.UPDATE_SKIP_OBSTRUCTION, null, null);
        }
        EventAction expectedAction = StatusType.STATUS_ADDED.equals((Object)contentsStatus) ? EventAction.UPDATE_ADD : (StatusType.STATUS_DELETED.equals((Object)contentsStatus) ? EventAction.UPDATE_DELETE : EventAction.UPDATE_UPDATE);
        EventAction action = expectedAction;
        if (haveTreeConflict) {
            action = EventAction.TREE_CONFLICT;
        }
        return new ProgressEvent(file, -1L, contentsStatus, propertiesStatus, action, null, null);
    }

    private static long matchAndGetRevision(Pattern pattern, String line) {
        Matcher matcher = pattern.matcher(line);
        if (matcher.matches()) {
            if (pattern == ourExportComplete) {
                return 0L;
            }
            String group = matcher.group(1);
            if (group == null) {
                return -1L;
            }
            try {
                return Long.parseLong(group);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1L;
    }

    @Nullable
    private static String parseComment(String line) {
        int index = line.lastIndexOf("--");
        return index != -1 && index < line.length() - 2 ? line.substring(index + 2).trim() : null;
    }

    @Nullable
    private File parseForPath(@NotNull String line) {
        int end;
        File result = null;
        int start = line.indexOf(39);
        if (start != -1 && (end = line.indexOf(39, start + 1)) != -1) {
            String path = line.substring(start + 1, end);
            result = SvnUtil.resolvePath(this.myBase, path);
        }
        return result;
    }
}

