/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.template.impl.activities.androidTVActivity.src.app_package;

import com.android.tools.idea.wizard.template.TemplateHelpersKt;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"cardPresenterKt", "", "packageName", "useAndroidX", "", "intellij.android.wizardTemplate.impl"})
public final class CardPresenterKtKt {
    @NotNull
    public static final String cardPresenterKt(@NotNull String packageName, boolean useAndroidX) {
        return "\npackage " + TemplateHelpersKt.escapeKotlinIdentifier(packageName) + "\n\nimport android.graphics.drawable.Drawable\nimport " + TemplateHelpersKt.getMaterialComponentName("android.support.v17.leanback.widget.ImageCardView", useAndroidX) + "\nimport " + TemplateHelpersKt.getMaterialComponentName("android.support.v17.leanback.widget.Presenter", useAndroidX) + "\nimport " + TemplateHelpersKt.getMaterialComponentName("android.support.v4.content.ContextCompat", useAndroidX) + "\nimport android.util.Log\nimport android.view.ViewGroup\n\nimport com.bumptech.glide.Glide\nimport kotlin.properties.Delegates\n\n/**\n * A CardPresenter is used to generate Views and bind Objects to them on demand.\n * It contains an ImageCardView.\n */\nclass CardPresenter : Presenter() {\n    private var mDefaultCardImage: Drawable?= null\n    private var sSelectedBackgroundColor: Int by Delegates.notNull()\n    private var sDefaultBackgroundColor: Int by Delegates.notNull()\n\n    override fun onCreateViewHolder(parent: ViewGroup): Presenter.ViewHolder {\n        Log.d(TAG, \"onCreateViewHolder\")\n\n        sDefaultBackgroundColor = ContextCompat.getColor(parent.context, R.color.default_background)\n        sSelectedBackgroundColor = ContextCompat.getColor(parent.context, R.color.selected_background)\n        mDefaultCardImage = ContextCompat.getDrawable(parent.context, R.drawable.movie)\n\n        val cardView = object : ImageCardView(parent.context) {\n            override fun setSelected(selected: Boolean) {\n                updateCardBackgroundColor(this, selected)\n                super.setSelected(selected)\n            }\n        }\n\n        cardView.isFocusable = true\n        cardView.isFocusableInTouchMode = true\n        updateCardBackgroundColor(cardView, false)\n        return Presenter.ViewHolder(cardView)\n    }\n\n    override fun onBindViewHolder(viewHolder: Presenter.ViewHolder, item: Any) {\n        val movie = item as Movie\n        val cardView = viewHolder.view as ImageCardView\n\n        Log.d(TAG, \"onBindViewHolder\")\n        if (movie.cardImageUrl != null) {\n            cardView.titleText = movie.title\n            cardView.contentText = movie.studio\n            cardView.setMainImageDimensions(CARD_WIDTH, CARD_HEIGHT)\n            Glide.with(viewHolder.view.context)\n                    .load(movie.cardImageUrl)\n                    .centerCrop()\n                    .error(mDefaultCardImage)\n                    .into(cardView.mainImageView)\n        }\n    }\n\n    override fun onUnbindViewHolder(viewHolder: Presenter.ViewHolder) {\n        Log.d(TAG, \"onUnbindViewHolder\")\n        val cardView = viewHolder.view as ImageCardView\n        // Remove references to images so that the garbage collector can free up memory\n        cardView.badgeImage = null\n        cardView.mainImage = null\n    }\n\n    private fun updateCardBackgroundColor(view: ImageCardView, selected: Boolean) {\n        val color = if (selected) sSelectedBackgroundColor else sDefaultBackgroundColor\n        // Both background colors should be set because the view\"s background is temporarily visible\n        // during animations.\n        view.setBackgroundColor(color)\n        view.setInfoAreaBackgroundColor(color)\n    }\n\n    companion object {\n        private val TAG = \"CardPresenter\"\n\n        private val CARD_WIDTH = 313\n        private val CARD_HEIGHT = 176\n    }\n}\n";
    }
}

