/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.rendering.api;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.utils.HashCodes;
import com.google.common.base.MoreObjects;
import java.io.Serializable;

public final class ResourceReference
implements Comparable<ResourceReference>,
Serializable {
    private final ResourceType resourceType;
    private final ResourceNamespace namespace;
    private final String name;

    public ResourceReference(ResourceNamespace namespace, ResourceType resourceType, String name) {
        assert (resourceType == ResourceType.SAMPLE_DATA || name.indexOf(58) < 0) : "Qualified name is not allowed: " + name;
        this.namespace = namespace;
        this.resourceType = resourceType;
        this.name = name;
    }

    public static ResourceReference attr(ResourceNamespace namespace, String name) {
        return new ResourceReference(namespace, ResourceType.ATTR, name);
    }

    public static ResourceReference style(ResourceNamespace namespace, String name) {
        return new ResourceReference(namespace, ResourceType.STYLE, name);
    }

    public static ResourceReference styleable(ResourceNamespace namespace, String name) {
        return new ResourceReference(namespace, ResourceType.STYLEABLE, name);
    }

    public String getName() {
        return this.name;
    }

    public String getQualifiedName() {
        String packageName = this.namespace.getPackageName();
        return packageName == null ? this.name : packageName + ':' + this.name;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public ResourceNamespace getNamespace() {
        return this.namespace;
    }

    @Deprecated
    public final boolean isFramework() {
        return ResourceNamespace.ANDROID.equals(this.namespace);
    }

    public ResourceUrl getResourceUrl() {
        return ResourceUrl.create(this.namespace.getPackageName(), this.resourceType, this.name);
    }

    public ResourceUrl getRelativeResourceUrl(ResourceNamespace context) {
        return this.getRelativeResourceUrl(context, ResourceNamespace.Resolver.EMPTY_RESOLVER);
    }

    public ResourceUrl getRelativeResourceUrl(ResourceNamespace context, ResourceNamespace.Resolver resolver) {
        String prefix;
        String namespaceString = this.namespace.equals(context) ? null : ((prefix = resolver.uriToPrefix(this.namespace.getXmlNamespaceUri())) != null ? prefix : this.namespace.getPackageName());
        return ResourceUrl.create(namespaceString, this.resourceType, this.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceReference reference = (ResourceReference)obj;
        if (this.resourceType != reference.resourceType) {
            return false;
        }
        if (!this.namespace.equals(reference.namespace)) {
            return false;
        }
        return this.name.equals(reference.name);
    }

    public int hashCode() {
        return HashCodes.mix((int)this.resourceType.hashCode(), (int)this.namespace.hashCode(), (int)this.name.hashCode());
    }

    @Override
    public int compareTo(ResourceReference other) {
        int diff = this.resourceType.compareTo(other.resourceType);
        if (diff != 0) {
            return diff;
        }
        diff = this.namespace.compareTo(other.namespace);
        if (diff != 0) {
            return diff;
        }
        return this.name.compareTo(other.name);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("namespace", (Object)this.namespace).add("type", (Object)this.resourceType).add("name", (Object)this.name).toString();
    }
}

