/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.resolve;

import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWildcardType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GrFunctionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.ClosureSamParameterEnhancer;

public class GradleClosureSamParameterEnhancer
extends ClosureSamParameterEnhancer {
    @Nullable
    protected PsiType getClosureParameterType(@NotNull GrFunctionalExpression expression, int index) {
        PsiFile file = expression.getContainingFile();
        if (file == null || !FileUtilRt.extensionEquals((String)file.getName(), (String)"gradle")) {
            return null;
        }
        PsiType psiType = super.getClosureParameterType(expression, index);
        if (psiType instanceof PsiWildcardType) {
            PsiWildcardType wildcardType = (PsiWildcardType)psiType;
            if (wildcardType.isSuper() && wildcardType.getBound() != null && wildcardType.getBound().equalsToText("org.gradle.api.tasks.SourceSet")) {
                return wildcardType.getBound();
            }
            if (wildcardType.isSuper() && wildcardType.getBound() != null && wildcardType.getBound().equalsToText("org.gradle.api.distribution.Distribution")) {
                return wildcardType.getBound();
            }
        }
        return null;
    }
}

