/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.integrations.javaee;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.DependencyData;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.tooling.model.idea.IdeaModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.ExternalDependency;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.model.data.Ear;
import org.jetbrains.plugins.gradle.model.data.EarConfigurationModelData;
import org.jetbrains.plugins.gradle.model.data.EarResource;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;
import org.jetbrains.plugins.gradle.model.data.War;
import org.jetbrains.plugins.gradle.model.data.WarDirectory;
import org.jetbrains.plugins.gradle.model.data.WebConfigurationModelData;
import org.jetbrains.plugins.gradle.model.data.WebResource;
import org.jetbrains.plugins.gradle.model.ear.EarConfiguration;
import org.jetbrains.plugins.gradle.model.web.WebConfiguration;
import org.jetbrains.plugins.gradle.service.project.AbstractProjectResolverExtension;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolver;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.service.project.LibraryDataNodeSubstitutor;
import org.jetbrains.plugins.gradle.service.project.ProjectResolverContext;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Order(value=1000)
public class JavaEEGradleProjectResolverExtension
extends AbstractProjectResolverExtension {
    private static final Key<Map<String, String>> ARCHIVES_ARTIFACTS = Key.create((String)"archivesArtifactsMap");
    private static final Key<List<Pair<DataNode<? extends ModuleData>, EarConfiguration>>> EAR_CONFIGURATIONS = Key.create((String)"earConfigurations");

    public void populateModuleExtraModels(@NotNull IdeaModule gradleModule, final @NotNull DataNode<ModuleData> ideModule) {
        EarConfiguration earConfiguration;
        WebConfiguration webConfiguration;
        DataNode projectDataNode = ideModule.getParent(ProjectData.class);
        NotNullLazyValue<DataNode<? extends ModuleData>> findTargetModuleNode = new NotNullLazyValue<DataNode<? extends ModuleData>>(){

            @NotNull
            protected DataNode<? extends ModuleData> compute() {
                String mainSourceSetModuleId = ((ModuleData)ideModule.getData()).getId() + ":main";
                DataNode targetModuleNode = ExternalSystemApiUtil.find((DataNode)ideModule, (com.intellij.openapi.externalSystem.model.Key)GradleSourceSetData.KEY, node -> mainSourceSetModuleId.equals(((GradleSourceSetData)node.getData()).getId()));
                if (targetModuleNode == null) {
                    targetModuleNode = ideModule;
                }
                return targetModuleNode;
            }
        };
        if (projectDataNode != null) {
            ExternalProject externalProject;
            Map archivesMap = (Map)projectDataNode.getUserData(ARCHIVES_ARTIFACTS);
            if (archivesMap == null) {
                archivesMap = new THashMap(FileUtil.PATH_HASHING_STRATEGY);
                projectDataNode.putUserData(ARCHIVES_ARTIFACTS, (Object)archivesMap);
            }
            if ((externalProject = (ExternalProject)this.resolverCtx.getExtraProject(gradleModule, ExternalProject.class)) != null && externalProject.getArtifactsByConfiguration().get("archives") != null) {
                HashSet archivesArtifacts = new HashSet((Collection)externalProject.getArtifactsByConfiguration().get("archives"));
                Set testsArtifacts = (Set)externalProject.getArtifactsByConfiguration().get("tests");
                if (testsArtifacts != null) {
                    archivesArtifacts.removeAll(testsArtifacts);
                }
                for (File artifactFile : archivesArtifacts) {
                    archivesMap.put(ExternalSystemApiUtil.toCanonicalPath((String)artifactFile.getAbsolutePath()), ((ModuleData)((DataNode)findTargetModuleNode.getValue()).getData()).getId());
                }
            }
        }
        if ((webConfiguration = (WebConfiguration)this.resolverCtx.getExtraProject(gradleModule, WebConfiguration.class)) != null) {
            List warModels = ContainerUtil.map((Collection)webConfiguration.getWarModels(), model -> {
                War war = new War(model.getWarName(), model.getWebAppDirName(), model.getWebAppDir());
                war.setWebXml(model.getWebXml());
                war.setWebResources(JavaEEGradleProjectResolverExtension.mapWebResources(model.getWebResources()));
                war.setClasspath(model.getClasspath());
                war.setManifestContent(model.getManifestContent());
                war.setArchivePath(model.getArchivePath());
                return war;
            });
            ((DataNode)findTargetModuleNode.getValue()).createChild(WebConfigurationModelData.KEY, (Object)new WebConfigurationModelData(GradleConstants.SYSTEM_ID, warModels));
        }
        if ((earConfiguration = (EarConfiguration)this.resolverCtx.getExtraProject(gradleModule, EarConfiguration.class)) != null && projectDataNode != null) {
            ArrayList<Pair> ears = (ArrayList<Pair>)projectDataNode.getUserData(EAR_CONFIGURATIONS);
            if (ears == null) {
                ears = new ArrayList<Pair>();
                projectDataNode.putUserData(EAR_CONFIGURATIONS, ears);
            }
            ears.add(Pair.create((Object)findTargetModuleNode.getValue(), (Object)earConfiguration));
        }
        this.nextResolver.populateModuleExtraModels(gradleModule, ideModule);
    }

    @NotNull
    public Set<Class<?>> getExtraProjectModelClasses() {
        return ContainerUtil.set((Object[])new Class[]{WebConfiguration.class, EarConfiguration.class});
    }

    public void resolveFinished(@NotNull DataNode<ProjectData> projectDataNode) {
        List earConfigurations = (List)projectDataNode.getUserData(EAR_CONFIGURATIONS);
        if (earConfigurations == null) {
            return;
        }
        for (Pair pair : earConfigurations) {
            DataNode moduleNode = (DataNode)pair.first;
            EarConfiguration earConfiguration = (EarConfiguration)pair.second;
            List warModels = ContainerUtil.map((Collection)earConfiguration.getEarModels(), model -> {
                Ear ear = new Ear(model.getEarName(), model.getAppDirName(), model.getLibDirName());
                ear.setManifestContent(model.getManifestContent());
                ear.setDeploymentDescriptor(model.getDeploymentDescriptor());
                ear.setResources(JavaEEGradleProjectResolverExtension.mapEarResources(model.getResources()));
                ear.setArchivePath(model.getArchivePath());
                return ear;
            });
            Collection<DependencyData> deployDependencies = JavaEEGradleProjectResolverExtension.getDependencies(this.resolverCtx, projectDataNode, (DataNode<? extends ModuleData>)moduleNode, earConfiguration.getDeployDependencies());
            Collection<DependencyData> earlibDependencies = JavaEEGradleProjectResolverExtension.getDependencies(this.resolverCtx, projectDataNode, (DataNode<? extends ModuleData>)moduleNode, earConfiguration.getEarlibDependencies());
            moduleNode.createChild(EarConfigurationModelData.KEY, (Object)new EarConfigurationModelData(GradleConstants.SYSTEM_ID, warModels, deployDependencies, earlibDependencies));
        }
    }

    private static List<WebResource> mapWebResources(List<WebConfiguration.WebResource> webResources) {
        return ContainerUtil.mapNotNull(webResources, resource -> {
            if (resource == null) {
                return null;
            }
            WarDirectory warDirectory = WarDirectory.fromPath((String)resource.getWarDirectory());
            return new WebResource(warDirectory, resource.getRelativePath(), resource.getFile());
        });
    }

    private static List<EarResource> mapEarResources(List<EarConfiguration.EarResource> resources) {
        return ContainerUtil.mapNotNull(resources, resource -> {
            if (resource == null) {
                return null;
            }
            return new EarResource(resource.getEarDirectory(), resource.getRelativePath(), resource.getFile());
        });
    }

    private static Collection<DependencyData> getDependencies(@NotNull ProjectResolverContext resolverCtx, @NotNull DataNode<ProjectData> ideProject, @NotNull DataNode<? extends ModuleData> moduleDataNode, @NotNull Collection<ExternalDependency> dependencies) throws IllegalStateException {
        Map allArtifactsMap;
        Map moduleOutputsMap = (Map)ideProject.getUserData(GradleProjectResolver.MODULES_OUTPUTS);
        assert (moduleOutputsMap != null);
        Map sourceSetMap = (Map)ideProject.getUserData(GradleProjectResolver.RESOLVED_SOURCE_SETS);
        assert (sourceSetMap != null);
        Map artifactsMap = (Map)ideProject.getUserData(GradleProjectResolver.CONFIGURATION_ARTIFACTS);
        assert (artifactsMap != null);
        Map archivesMap = (Map)ideProject.getUserData(ARCHIVES_ARTIFACTS);
        if (archivesMap != null && !archivesMap.isEmpty()) {
            allArtifactsMap = new THashMap(FileUtil.PATH_HASHING_STRATEGY);
            allArtifactsMap.putAll(artifactsMap);
            allArtifactsMap.putAll(archivesMap);
        } else {
            allArtifactsMap = artifactsMap;
        }
        DataNode fakeNode = new DataNode(moduleDataNode.getKey(), moduleDataNode.getData(), null);
        GradleProjectResolverUtil.buildDependencies((ProjectResolverContext)resolverCtx, (Map)sourceSetMap, (Map)allArtifactsMap, (DataNode)fakeNode, dependencies, null);
        LibraryDataNodeSubstitutor librarySubstitutor = new LibraryDataNodeSubstitutor(resolverCtx, null, null, null, sourceSetMap, moduleOutputsMap, artifactsMap);
        Collection libraryDependencies = ExternalSystemApiUtil.findAllRecursively((DataNode)fakeNode, (com.intellij.openapi.externalSystem.model.Key)ProjectKeys.LIBRARY_DEPENDENCY);
        for (DataNode libraryDependencyDataNode : libraryDependencies) {
            librarySubstitutor.run(libraryDependencyDataNode);
        }
        Collection dataNodes = ExternalSystemApiUtil.findAllRecursively((DataNode)fakeNode, node -> node.getData() instanceof DependencyData);
        return ContainerUtil.map((Collection)dataNodes, node -> (DependencyData)node.getData());
    }
}

