/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.regex;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.ContainerUtil;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.regex.MatchData;
import org.jetbrains.plugins.textmate.regex.Searcher;
import org.jetbrains.plugins.textmate.regex.StringWithId;
import org.joni.Matcher;
import org.joni.Regex;
import org.joni.exception.JOniException;

public class RegexFacade {
    private static final Regex FAILED_REGEX = new Regex("^$", (Encoding)UTF8Encoding.INSTANCE);
    private static final Logger LOGGER = Logger.getInstance(RegexFacade.class);
    @NotNull
    private final Regex myRegex;
    private final ThreadLocal<LastMatch> matchResult = new ThreadLocal();
    private static final Map<String, RegexFacade> REGEX_CACHE = ContainerUtil.createConcurrentSoftKeySoftValueMap();

    private RegexFacade(@NotNull String regexString) {
        Regex regex;
        byte[] bytes = regexString.getBytes(StandardCharsets.UTF_8);
        try {
            regex = new Regex(bytes, 0, bytes.length, 256, (Encoding)UTF8Encoding.INSTANCE);
        }
        catch (JOniException e) {
            LOGGER.info("Failed to parse textmate regex", (Throwable)e);
            regex = FAILED_REGEX;
        }
        this.myRegex = regex;
    }

    public MatchData match(StringWithId string, @Nullable Runnable checkCancelledCallback) {
        return this.match(string, 0, checkCancelledCallback);
    }

    public MatchData match(@NotNull StringWithId string, int byteOffset, @Nullable Runnable checkCancelledCallback) {
        MatchData lastMatch;
        LastMatch lastResult = this.matchResult.get();
        Object lastId = lastResult != null ? lastResult.lastId : null;
        int lastOffset = lastResult != null ? lastResult.lastOffset : Integer.MAX_VALUE;
        MatchData matchData = lastMatch = lastResult != null ? lastResult.lastMatch : MatchData.NOT_MATCHED;
        if (!(lastId != string.id || lastOffset > byteOffset || lastMatch.matched() && lastMatch.byteOffset().start < byteOffset)) {
            RegexFacade.checkMatched(lastMatch, string);
            return lastMatch;
        }
        if (checkCancelledCallback != null) {
            checkCancelledCallback.run();
        }
        lastId = string.id;
        lastOffset = byteOffset;
        Matcher matcher = this.myRegex.matcher(string.bytes);
        int matchIndex = matcher.search(byteOffset, string.bytes.length, 256);
        lastMatch = matchIndex > -1 ? MatchData.fromRegion(matcher.getEagerRegion()) : MatchData.NOT_MATCHED;
        RegexFacade.checkMatched(lastMatch, string);
        this.matchResult.set(new LastMatch(lastId, lastOffset, lastMatch));
        return lastMatch;
    }

    private static void checkMatched(MatchData match, StringWithId string) {
        if (match.matched() && match.byteOffset().end > string.bytes.length) {
            throw new IllegalStateException("Match data out of bounds: " + match.byteOffset().start + " > " + string.bytes.length + "\n" + new String(string.bytes, StandardCharsets.UTF_8));
        }
    }

    public Searcher searcher(byte[] stringBytes) {
        return new Searcher(stringBytes, this.myRegex.matcher(stringBytes, 0, stringBytes.length));
    }

    @NotNull
    public static RegexFacade regex(@NotNull String regexString) {
        return REGEX_CACHE.computeIfAbsent(regexString, RegexFacade::new);
    }

    private static class LastMatch {
        private final Object lastId;
        private final int lastOffset;
        private final MatchData lastMatch;

        private LastMatch(Object id, int offset, MatchData data) {
            this.lastId = id;
            this.lastOffset = offset;
            this.lastMatch = data;
        }
    }
}

