/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.preferences;

import com.intellij.util.containers.MultiMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.language.TextMateScopeComparator;
import org.jetbrains.plugins.textmate.language.preferences.TextMateShellVariable;
import org.jetbrains.plugins.textmate.plist.PListValue;
import org.jetbrains.plugins.textmate.plist.Plist;

public class ShellVariablesRegistry {
    @NotNull
    private final MultiMap<String, TextMateShellVariable> myVariables = MultiMap.create();

    public void fillVariablesFromPlist(@NotNull CharSequence scopeName, @NotNull Plist plist) {
        PListValue shellVariables = plist.getPlistValue("shellVariables");
        if (shellVariables != null) {
            for (PListValue variable : shellVariables.getArray()) {
                Plist variablePlist = variable.getPlist();
                String name = variablePlist.getPlistValue("name", "").getString();
                String value = variablePlist.getPlistValue("value", "").getString();
                if (name.isEmpty()) continue;
                this.myVariables.putValue((Object)name, (Object)new TextMateShellVariable(scopeName, name, value));
            }
        }
    }

    @Nullable
    public TextMateShellVariable getVariableValue(@NotNull String name, @Nullable CharSequence scopeSelector) {
        if (scopeSelector == null) {
            return null;
        }
        return new TextMateScopeComparator<TextMateShellVariable>(scopeSelector, TextMateShellVariable::getScopeSelector).max(this.myVariables.get((Object)name));
    }

    public void clear() {
        this.myVariables.clear();
    }
}

