/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.analysis.XmlAnalysisBundle;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlDeclareIdInCommentAction
implements LocalQuickFix {
    private final String myId;

    public XmlDeclareIdInCommentAction(@NotNull String id) {
        this.myId = id;
    }

    @NotNull
    public String getFamilyName() {
        return XmlAnalysisBundle.message((String)"declare.id.in.comment.quickfix", (Object[])new Object[0]);
    }

    @Nullable
    public static String getImplicitlyDeclaredId(@NotNull PsiComment comment) {
        String text = XmlDeclareIdInCommentAction.getUncommentedText(comment);
        if (text == null) {
            return null;
        }
        if (text.startsWith("@declare id=\"")) {
            String result = text.substring("@declare id=\"".length() - 1);
            return StringUtil.unquoteString((String)result);
        }
        return null;
    }

    @Nullable
    private static String getUncommentedText(@NotNull PsiComment comment) {
        PsiFile psiFile = comment.getContainingFile();
        Language language = psiFile.getViewProvider().getBaseLanguage();
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(language);
        if (commenter != null) {
            String text = comment.getText();
            String prefix = commenter.getBlockCommentPrefix();
            if (prefix != null && text.startsWith(prefix)) {
                text = text.substring(prefix.length());
                String suffix = commenter.getBlockCommentSuffix();
                if (suffix != null && text.length() > suffix.length()) {
                    return text.substring(0, text.length() - suffix.length()).trim();
                }
            }
        }
        return null;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement psiElement = descriptor.getPsiElement();
        PsiFile psiFile = psiElement.getContainingFile();
        WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{psiFile}).run(() -> {
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)psiElement, XmlTag.class);
            if (tag == null) {
                return;
            }
            Language language = psiFile.getViewProvider().getBaseLanguage();
            Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(language);
            if (commenter == null) {
                return;
            }
            String commentText = commenter.getBlockCommentPrefix() + "@declare id=\"" + this.myId + "\"" + commenter.getBlockCommentSuffix();
            XmlTag parent = tag.getParentTag();
            if (parent != null) {
                Document document = Objects.requireNonNull(psiFile.getViewProvider().getDocument());
                document.insertString(parent.getSubTags()[0].getTextRange().getStartOffset(), (CharSequence)commentText);
            }
        });
    }
}

