/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.index;

import com.intellij.ide.highlighter.DTDFileType;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.AdditionalIndexedRootsScope;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.IOUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.xml.index.IndexedRelevantResource;
import com.intellij.xml.index.ResourceRelevance;
import com.intellij.xml.index.XmlIndex;
import com.intellij.xml.index.XsdNamespaceBuilder;
import com.intellij.xml.util.XmlUtil;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlNamespaceIndex
extends XmlIndex<XsdNamespaceBuilder> {
    private static final String LOCAL_SCHEMA_ID = "$LOCAL_SCHEMA$";
    public static final ID<String, XsdNamespaceBuilder> NAME = ID.create((String)"XmlNamespaces");
    private static final String NULL_STRING = "\"\"";

    @Nullable
    public static String getNamespace(@NotNull VirtualFile file, Project project) {
        if (DumbService.isDumb((Project)project) || XmlUtil.isStubBuilding()) {
            return XmlNamespaceIndex.computeNamespace(file);
        }
        XsdNamespaceBuilder item = XmlNamespaceIndex.getFileNamespace(file, project);
        if (item == null) {
            return null;
        }
        String namespace = item.getNamespace();
        return namespace != null ? namespace : file.getUrl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String computeNamespace(@NotNull VirtualFile file) {
        InputStream stream = null;
        try {
            stream = file.getInputStream();
            String string = XsdNamespaceBuilder.computeNamespace(stream);
            return string;
        }
        catch (IOException e) {
            String string = null;
            return string;
        }
        finally {
            StreamUtil.closeStream((Closeable)stream);
        }
    }

    public static List<IndexedRelevantResource<String, XsdNamespaceBuilder>> getResourcesByNamespace(String namespace, @NotNull Project project, @Nullable Module module) {
        List<IndexedRelevantResource<String, XsdNamespaceBuilder>> resources = IndexedRelevantResource.getResources(NAME, namespace, module, project, null);
        resources.addAll(XmlNamespaceIndex.getDtdResources(namespace, module, project));
        ContainerUtil.addIfNotNull(resources, XmlNamespaceIndex.getResourceByLocalFile(namespace, project, module));
        Collections.sort(resources);
        return resources;
    }

    @Nullable
    private static IndexedRelevantResource<String, XsdNamespaceBuilder> getResourceByLocalFile(String namespace, @NotNull Project project, @Nullable Module module) {
        XsdNamespaceBuilder xsdNamespaceBuilder;
        VirtualFile file;
        String protocol = VirtualFileManager.extractProtocol((String)namespace);
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        if (virtualFileManager.getFileSystem(protocol) instanceof LocalFileSystem && (file = virtualFileManager.findFileByUrl(namespace)) != null && (xsdNamespaceBuilder = XmlNamespaceIndex.getFileNamespace(file, project)) != null) {
            ResourceRelevance relevance = ResourceRelevance.getRelevance(file, module, ProjectFileIndex.getInstance((Project)project), null);
            return new IndexedRelevantResource<String, XsdNamespaceBuilder>(file, file.getUrl(), xsdNamespaceBuilder, relevance);
        }
        return null;
    }

    @Nullable
    private static XsdNamespaceBuilder getFileNamespace(@NotNull VirtualFile file, @NotNull Project project) {
        if (FileTypeRegistry.getInstance().isFileOfType(file, (FileType)DTDFileType.INSTANCE)) {
            return new XsdNamespaceBuilder(file.getName(), "", Collections.emptyList(), Collections.emptyList());
        }
        Map data = FileBasedIndex.getInstance().getFileData(NAME, file, project);
        return (XsdNamespaceBuilder)ContainerUtil.getFirstItem(data.values());
    }

    public static List<IndexedRelevantResource<String, XsdNamespaceBuilder>> getAllResources(@Nullable Module module, @NotNull Project project) {
        List<IndexedRelevantResource<String, XsdNamespaceBuilder>> xmlResources = IndexedRelevantResource.getAllResources(NAME, module, project, null);
        List<IndexedRelevantResource<String, XsdNamespaceBuilder>> dtdResources = XmlNamespaceIndex.getDtdResources(null, module, project);
        return ContainerUtil.concat(xmlResources, dtdResources);
    }

    @NotNull
    private static List<IndexedRelevantResource<String, XsdNamespaceBuilder>> getDtdResources(@Nullable String namespace, @Nullable Module module, @NotNull Project project) {
        AdditionalIndexedRootsScope scope = new AdditionalIndexedRootsScope(GlobalSearchScope.allScope((Project)project));
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
        Function resourceFunction = f -> {
            ResourceRelevance relevance = ResourceRelevance.getRelevance(f, module, index, (GlobalSearchScope)scope);
            return new IndexedRelevantResource<String, XsdNamespaceBuilder>((VirtualFile)f, f.getName(), XmlNamespaceIndex.getFileNamespace(f, project), relevance);
        };
        Collection dtdFiles = namespace == null ? FileTypeIndex.getFiles((FileType)DTDFileType.INSTANCE, (GlobalSearchScope)scope) : ContainerUtil.filter((Collection)FilenameIndex.getVirtualFilesByName((Project)project, (String)namespace, (GlobalSearchScope)scope), f -> FileTypeRegistry.getInstance().isFileOfType(f, (FileType)DTDFileType.INSTANCE));
        return ContainerUtil.map((Collection)dtdFiles, (Function)resourceFunction);
    }

    @NotNull
    public ID<String, XsdNamespaceBuilder> getName() {
        return NAME;
    }

    @Override
    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return new DefaultFileTypeSpecificInputFilter(new FileType[]{XmlFileType.INSTANCE}){

            public boolean acceptInput(@NotNull VirtualFile file) {
                return "xsd".equals(file.getExtension());
            }
        };
    }

    @NotNull
    public DataIndexer<String, XsdNamespaceBuilder, FileContent> getIndexer() {
        return new DataIndexer<String, XsdNamespaceBuilder, FileContent>(){

            @NotNull
            public Map<String, XsdNamespaceBuilder> map(@NotNull FileContent inputData) {
                XsdNamespaceBuilder builder = XsdNamespaceBuilder.computeNamespace(CharArrayUtil.readerFromCharSequence((CharSequence)inputData.getContentAsText()));
                String namespace = builder.getNamespace();
                return Collections.singletonMap(ObjectUtils.notNull((Object)namespace, (Object)XmlNamespaceIndex.LOCAL_SCHEMA_ID), builder);
            }
        };
    }

    @NotNull
    public DataExternalizer<XsdNamespaceBuilder> getValueExternalizer() {
        return new DataExternalizer<XsdNamespaceBuilder>(){

            public void save(@NotNull DataOutput out, XsdNamespaceBuilder value) throws IOException {
                IOUtil.writeUTF((DataOutput)out, (String)(value.getNamespace() != null ? value.getNamespace() : XmlNamespaceIndex.NULL_STRING));
                IOUtil.writeUTF((DataOutput)out, (String)(value.getVersion() != null ? value.getVersion() : XmlNamespaceIndex.NULL_STRING));
                IOUtil.writeStringList((DataOutput)out, value.getTags());
                IOUtil.writeStringList((DataOutput)out, value.getRootTags());
            }

            public XsdNamespaceBuilder read(@NotNull DataInput in) throws IOException {
                String version;
                String namespace = IOUtil.readUTF((DataInput)in);
                if (XmlNamespaceIndex.NULL_STRING.equals(namespace)) {
                    namespace = null;
                }
                if (XmlNamespaceIndex.NULL_STRING.equals(version = IOUtil.readUTF((DataInput)in))) {
                    version = null;
                }
                return new XsdNamespaceBuilder(namespace, version, IOUtil.readStringList((DataInput)in), IOUtil.readStringList((DataInput)in));
            }
        };
    }

    @Override
    public int getVersion() {
        return 8;
    }

    @Nullable
    public static IndexedRelevantResource<String, XsdNamespaceBuilder> guessSchema(String namespace, @Nullable String tagName, @Nullable String version, @Nullable String schemaLocation, @Nullable Module module, @NotNull Project project) {
        List<IndexedRelevantResource<String, XsdNamespaceBuilder>> resources = XmlNamespaceIndex.getResourcesByNamespace(namespace, project, module);
        if (resources.isEmpty()) {
            return null;
        }
        if (resources.size() == 1) {
            return resources.get(0);
        }
        String fileName = schemaLocation == null ? null : new File(schemaLocation).getName();
        IndexedRelevantResource<String, XsdNamespaceBuilder> resource = Collections.max(resources, (o1, o2) -> {
            int i;
            if (fileName != null && (i = Comparing.compare((boolean)fileName.equals(o1.getFile().getName()), (boolean)fileName.equals(o2.getFile().getName()))) != 0) {
                return i;
            }
            if (tagName != null && (i = Comparing.compare((boolean)((XsdNamespaceBuilder)o1.getValue()).hasTag(tagName), (boolean)((XsdNamespaceBuilder)o2.getValue()).hasTag(tagName))) != 0) {
                return i;
            }
            i = o1.compareTo(o2);
            if (i != 0) {
                return i;
            }
            return ((XsdNamespaceBuilder)o1.getValue()).getRating(tagName, version) - ((XsdNamespaceBuilder)o2.getValue()).getRating(tagName, version);
        });
        if (tagName != null && !resource.getValue().hasTag(tagName)) {
            return null;
        }
        return resource;
    }

    @Nullable
    public static XmlFile guessSchema(String namespace, @Nullable String tagName, @Nullable String version, @Nullable String schemaLocation, @NotNull PsiFile file) {
        if (DumbService.isDumb((Project)file.getProject()) || XmlUtil.isStubBuilding()) {
            return null;
        }
        IndexedRelevantResource<String, XsdNamespaceBuilder> resource = XmlNamespaceIndex.guessSchema(namespace, tagName, version, schemaLocation, ModuleUtilCore.findModuleForPsiElement((PsiElement)file), file.getProject());
        if (resource == null) {
            return null;
        }
        return XmlNamespaceIndex.findSchemaFile(resource.getFile(), file);
    }

    @Nullable
    private static XmlFile findSchemaFile(VirtualFile resourceFile, PsiFile baseFile) {
        PsiFile psiFile = baseFile.getManager().findFile(resourceFile);
        return psiFile instanceof XmlFile ? (XmlFile)psiFile : null;
    }

    @Nullable
    public static XmlFile guessDtd(String dtdUri, @NotNull PsiFile baseFile) {
        IndexedRelevantResource<String, XsdNamespaceBuilder> resource;
        if (!dtdUri.endsWith(".dtd") || DumbService.isDumb((Project)baseFile.getProject()) || XmlUtil.isStubBuilding()) {
            return null;
        }
        String dtdFileName = new File(dtdUri).getName();
        List<IndexedRelevantResource<String, XsdNamespaceBuilder>> list = XmlNamespaceIndex.getResourcesByNamespace(dtdFileName, baseFile.getProject(), ModuleUtilCore.findModuleForPsiElement((PsiElement)baseFile));
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() > 1) {
            final String[] split = dtdUri.split("/");
            resource = Collections.max(list, new Comparator<IndexedRelevantResource<String, XsdNamespaceBuilder>>(){

                @Override
                public int compare(IndexedRelevantResource<String, XsdNamespaceBuilder> o1, IndexedRelevantResource<String, XsdNamespaceBuilder> o2) {
                    return this.weight(o1) - this.weight(o2);
                }

                int weight(IndexedRelevantResource<String, XsdNamespaceBuilder> o1) {
                    VirtualFile file = o1.getFile();
                    for (int i = split.length - 1; i >= 0 && file != null; file = file.getParent(), --i) {
                        String s = split[i];
                        if (s.equals(file.getName())) continue;
                        return split.length - i;
                    }
                    return 0;
                }
            });
        } else {
            resource = list.get(0);
        }
        return XmlNamespaceIndex.findSchemaFile(resource.getFile(), baseFile);
    }
}

