/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.breadcrumbs;

import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.xhtml.XHTMLLanguage;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.breadcrumbs.BreadcrumbsProvider;
import com.intellij.xml.util.HtmlUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlLanguageBreadcrumbsInfoProvider
implements BreadcrumbsProvider {
    public boolean acceptElement(@NotNull PsiElement e) {
        return e instanceof XmlTag && e.isValid();
    }

    public Language[] getLanguages() {
        return new Language[]{XMLLanguage.INSTANCE, XHTMLLanguage.INSTANCE, HTMLLanguage.INSTANCE};
    }

    @NotNull
    public String getElementInfo(@NotNull PsiElement e) {
        return XmlLanguageBreadcrumbsInfoProvider.getInfo(e);
    }

    @NotNull
    public static String getInfo(@NotNull PsiElement e) {
        XmlTag tag = (XmlTag)e;
        boolean addHtmlInfo = e.getContainingFile().getLanguage() != XMLLanguage.INSTANCE;
        return addHtmlInfo ? HtmlUtil.getTagPresentation(tag) : tag.getName();
    }

    @Nullable
    public String getElementTooltip(@NotNull PsiElement e) {
        return XmlLanguageBreadcrumbsInfoProvider.getTooltip((XmlTag)e);
    }

    @NotNull
    public static String getTooltip(@NotNull XmlTag tag) {
        XmlAttribute[] attributes;
        StringBuilder result = new StringBuilder("&lt;");
        result.append(tag.getName());
        for (XmlAttribute each : attributes = tag.getAttributes()) {
            result.append(" ").append(each.getText());
        }
        if (tag.isEmpty()) {
            result.append("/&gt;");
        } else {
            result.append("&gt;...&lt;/").append(tag.getName()).append("&gt;");
        }
        return result.toString();
    }
}

