/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.lang.ASTNode;
import com.intellij.psi.HintedReferenceHost;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.impl.meta.MetaRegistry;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.xml.XmlStubBasedElement;
import com.intellij.psi.impl.source.xml.XmlTagDelegate;
import com.intellij.psi.impl.source.xml.XmlTagValueImpl;
import com.intellij.psi.impl.source.xml.stub.XmlTagStub;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.util.XmlUtil;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class XmlStubBasedTagBase<StubT extends XmlTagStub<?>>
extends XmlStubBasedElement<StubT>
implements XmlTag,
HintedReferenceHost,
StubBasedPsiElement<StubT> {
    @Nullable
    private volatile XmlTagDelegate myImpl;
    private volatile XmlTagValue myValue;
    private volatile XmlAttribute[] myAttributes;

    XmlStubBasedTagBase(@NotNull StubT stub, @NotNull IStubElementType nodeType) {
        super(stub, nodeType);
    }

    XmlStubBasedTagBase(@NotNull ASTNode node) {
        super(node);
    }

    @NotNull
    private XmlTagDelegate getImpl() {
        XmlTagDelegate impl = this.myImpl;
        if (impl != null) {
            return impl;
        }
        this.myImpl = impl = this.createDelegate();
        return impl;
    }

    protected XmlTagDelegate createDelegate() {
        return new XmlStubBasedTagDelegate();
    }

    @Override
    public void subtreeChanged() {
        super.subtreeChanged();
        this.myImpl = null;
        this.myValue = null;
        this.myAttributes = null;
    }

    @Override
    public PsiElement getContext() {
        XmlTagStub stub = (XmlTagStub)this.getStub();
        if (stub != null && !(stub instanceof PsiFileStub)) {
            return stub.getParentStub().getPsi();
        }
        return super.getParent();
    }

    @Deprecated
    public final PsiReference @NotNull [] getReferences() {
        return this.getReferences(PsiReferenceService.Hints.NO_HINTS);
    }

    public boolean shouldAskParentForReferences(@NotNull PsiReferenceService.Hints hints) {
        return false;
    }

    public PsiReference @NotNull [] getReferences(@NotNull PsiReferenceService.Hints hints) {
        return this.getImpl().getDefaultReferences(hints);
    }

    public XmlNSDescriptor getNSDescriptor(String namespace, boolean strict) {
        return this.getImpl().getNSDescriptor(namespace, strict);
    }

    public boolean isEmpty() {
        return XmlChildRole.CLOSING_TAG_START_FINDER.findChild(this.getNode()) == null;
    }

    public void collapseIfEmpty() {
        this.getImpl().collapseIfEmpty();
    }

    @Nullable
    @NonNls
    public String getSubTagText(@NonNls String qname) {
        XmlTag tag = this.findFirstSubTag(qname);
        if (tag == null) {
            return null;
        }
        return tag.getValue().getText();
    }

    public PsiReference getReference() {
        return (PsiReference)ArrayUtil.getFirstElement((Object[])this.getReferences(PsiReferenceService.Hints.NO_HINTS));
    }

    public XmlElementDescriptor getDescriptor() {
        return this.getImpl().getDescriptor();
    }

    @NotNull
    public String getName() {
        return this.getImpl().getName();
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        return this.getImpl().setName(name);
    }

    public XmlAttribute @NotNull [] getAttributes() {
        XmlAttribute[] attributes = this.myAttributes;
        if (attributes == null) {
            this.myAttributes = attributes = this.getImpl().calculateAttributes();
        }
        return (XmlAttribute[])attributes.clone();
    }

    public String getAttributeValue(String qname) {
        return this.getImpl().getAttributeValue(qname);
    }

    public String getAttributeValue(String _name, String namespace) {
        return this.getImpl().getAttributeValue(_name, namespace);
    }

    public XmlTag @NotNull [] getSubTags() {
        return this.getSubTags(XmlStubBasedTagBase.shouldProcessIncludesNow());
    }

    public XmlTag[] getSubTags(boolean processIncludes) {
        return this.getImpl().getSubTags(processIncludes);
    }

    public static boolean shouldProcessIncludesNow() {
        return FileBasedIndex.getInstance().getFileBeingCurrentlyIndexed() == null && !XmlUtil.isStubBuilding();
    }

    public XmlTag @NotNull [] findSubTags(@NotNull String name) {
        return this.findSubTags(name, null);
    }

    public XmlTag @NotNull [] findSubTags(@NotNull String name, @Nullable String namespace) {
        return this.getImpl().findSubTags(name, namespace);
    }

    public XmlTag findFirstSubTag(String name) {
        return this.getImpl().findFirstSubTag(name);
    }

    public XmlAttribute getAttribute(String name, String namespace) {
        return this.getImpl().getAttribute(name, namespace);
    }

    @Nullable
    public XmlAttribute getAttribute(String qname) {
        return this.getImpl().getAttribute(qname);
    }

    public boolean isCaseSensitive() {
        return true;
    }

    @NotNull
    public String getNamespace() {
        return (String)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create((Object)this.getNamespaceByPrefix(this.getNamespacePrefix()), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    @NotNull
    public String getNamespacePrefix() {
        return this.getImpl().getNamespacePrefix(this.getName());
    }

    @NotNull
    public String getNamespaceByPrefix(String prefix) {
        return this.getImpl().getNamespaceByPrefix(prefix);
    }

    public String getPrefixByNamespace(String namespace) {
        return this.getImpl().getPrefixByNamespace(namespace);
    }

    public String[] knownNamespaces() {
        return this.getImpl().knownNamespaces();
    }

    @NotNull
    public String getLocalName() {
        return this.getImpl().getLocalName();
    }

    public boolean hasNamespaceDeclarations() {
        return this.getImpl().hasNamespaceDeclarations();
    }

    @NotNull
    public Map<String, String> getLocalNamespaceDeclarations() {
        return this.getImpl().getLocalNamespaceDeclarations();
    }

    public XmlAttribute setAttribute(String qname, String value) throws IncorrectOperationException {
        return this.getImpl().setAttribute(qname, value);
    }

    public XmlAttribute setAttribute(String name, String namespace, String value) throws IncorrectOperationException {
        return this.getImpl().setAttribute(name, namespace, value);
    }

    public XmlTag createChildTag(String localName, String namespace, String bodyText, boolean enforceNamespacesDeep) {
        return XmlUtil.createChildTag(this, localName, namespace, bodyText, enforceNamespacesDeep);
    }

    protected XmlTagValue createXmlTagValue() {
        return XmlTagValueImpl.createXmlTagValue(this);
    }

    public XmlTag addSubTag(XmlTag subTag, boolean first) {
        return this.getImpl().addSubTag(subTag, first);
    }

    @NotNull
    public XmlTagValue getValue() {
        XmlTagValue tagValue = this.myValue;
        if (tagValue == null) {
            this.myValue = tagValue = this.createXmlTagValue();
        }
        return tagValue;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof XmlElementVisitor) {
            ((XmlElementVisitor)visitor).visitXmlTag((XmlTag)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    public String toString() {
        return "XmlTag:" + this.getName();
    }

    public PsiMetaData getMetaData() {
        return MetaRegistry.getMeta((PsiElement)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ASTNode addInternal(ASTNode first, ASTNode last, ASTNode anchor, Boolean beforeB) {
        if (!(first instanceof TreeElement)) {
            return null;
        }
        TreeElement firstAppended = null;
        boolean before = beforeB == null || beforeB != false;
        try {
            TreeElement next;
            do {
                next = ((TreeElement)first).getTreeNext();
                if (firstAppended == null) {
                    firstAppended = this.getImpl().addInternal((TreeElement)first, anchor, before);
                    anchor = firstAppended;
                    continue;
                }
                anchor = this.getImpl().addInternal((TreeElement)first, anchor, false);
            } while (first != last && (first = next) != null);
        }
        finally {
            this.subtreeChanged();
        }
        return firstAppended;
    }

    public void deleteChildInternal(@NotNull ASTNode child) {
        this.getImpl().deleteChildInternal(child);
    }

    protected void deleteChildInternalSuper(@NotNull ASTNode child) {
        super.deleteChildInternal(child);
    }

    protected TreeElement addInternalSuper(TreeElement first, ASTNode last, @Nullable ASTNode anchor, @Nullable Boolean before) {
        return (TreeElement)super.addInternal((ASTNode)first, last, anchor, before);
    }

    public XmlTag getParentTag() {
        PsiElement parent = this.getParentByStub();
        if (parent instanceof XmlTag) {
            return (XmlTag)parent;
        }
        return null;
    }

    public XmlTagChild getNextSiblingInTag() {
        PsiElement nextSibling = this.getNextSibling();
        if (nextSibling instanceof XmlTagChild) {
            return (XmlTagChild)nextSibling;
        }
        return null;
    }

    public XmlTagChild getPrevSiblingInTag() {
        PsiElement prevSibling = this.getPrevSibling();
        if (prevSibling instanceof XmlTagChild) {
            return (XmlTagChild)prevSibling;
        }
        return null;
    }

    public Icon getElementIcon(int flags) {
        return PlatformIcons.XML_TAG_ICON;
    }

    protected class XmlStubBasedTagDelegate
    extends XmlTagDelegate {
        public XmlStubBasedTagDelegate() {
            super(XmlStubBasedTagBase.this);
        }

        @Override
        protected void deleteChildInternalSuper(@NotNull ASTNode child) {
            XmlStubBasedTagBase.this.deleteChildInternalSuper(child);
        }

        @Override
        protected TreeElement addInternalSuper(TreeElement first, ASTNode last, @Nullable ASTNode anchor, @Nullable Boolean before) {
            return XmlStubBasedTagBase.this.addInternalSuper(first, last, anchor, before);
        }
    }
}

