/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.xml.XmlElementImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.util.XmlPsiUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
abstract class XmlStubBasedElement<T extends StubElement<?>>
extends StubBasedPsiElementBase<T>
implements XmlElement {
    XmlStubBasedElement(@NotNull T stub, @NotNull IStubElementType nodeType) {
        super(stub, nodeType);
    }

    XmlStubBasedElement(@NotNull ASTNode node) {
        super(node);
    }

    public boolean processElements(PsiElementProcessor processor, PsiElement place) {
        return XmlPsiUtil.processXmlElements(this, (PsiElementProcessor<? super PsiElement>)processor, false);
    }

    public PsiElement getContext() {
        XmlElement data = (XmlElement)this.getUserData(INCLUDING_ELEMENT);
        if (data != null) {
            return data;
        }
        return super.getContext();
    }

    @NotNull
    public PsiElement getNavigationElement() {
        if (!this.isPhysical()) {
            XmlElement including = (XmlElement)this.getUserData(INCLUDING_ELEMENT);
            if (including != null) {
                return including;
            }
            PsiElement astParent = super.getParent();
            PsiElement parentNavigation = astParent.getNavigationElement();
            if (parentNavigation.getTextOffset() == this.getTextOffset()) {
                return parentNavigation;
            }
            return this;
        }
        return super.getNavigationElement();
    }

    public PsiElement getParent() {
        XmlElement data = (XmlElement)this.getUserData(INCLUDING_ELEMENT);
        if (data != null) {
            return data;
        }
        return super.getParent();
    }

    @NotNull
    public Language getLanguage() {
        return this.getContainingFile().getLanguage();
    }

    @NotNull
    public SearchScope getUseScope() {
        return GlobalSearchScope.allScope((Project)this.getProject());
    }

    public boolean isEquivalentTo(PsiElement another) {
        if (super.isEquivalentTo(another)) {
            return true;
        }
        XmlStubBasedElement element1 = this;
        if (element1 instanceof XmlTag && another instanceof XmlTag && !element1.isPhysical() && !another.isPhysical()) {
            return element1.getText().equals(another.getText());
        }
        return false;
    }

    public boolean skipValidation() {
        return XmlElementImpl.skipValidation(this);
    }

    public void subtreeChanged() {
        super.subtreeChanged();
        this.putUserData(DO_NOT_VALIDATE, null);
    }

    public PsiElement @NotNull [] getChildren() {
        PsiElement psiChild = this.getFirstChild();
        if (psiChild == null) {
            return PsiElement.EMPTY_ARRAY;
        }
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        while (psiChild != null) {
            result.add(psiChild);
            psiChild = psiChild.getNextSibling();
        }
        return PsiUtilCore.toPsiElementArray(result);
    }

    public String toString() {
        return "PsiElement(" + this.getElementType() + ")";
    }
}

