/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.xhtml.XHTMLLanguage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.html.ScriptSupportUtil;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NotNull;

public class XmlFileImpl
extends PsiFileImpl
implements XmlFile {
    private FileType myType = null;

    public XmlFileImpl(FileViewProvider viewProvider, IElementType elementType) {
        super(elementType, elementType, viewProvider);
    }

    public XmlDocument getDocument() {
        for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof XmlDocument)) continue;
            return (XmlDocument)child;
        }
        return null;
    }

    public XmlTag getRootTag() {
        XmlDocument document = this.getDocument();
        return document == null ? null : document.getRootTag();
    }

    public boolean processElements(PsiElementProcessor processor, PsiElement place) {
        XmlDocument document = this.getDocument();
        return document == null || document.processElements(processor, place);
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof XmlElementVisitor) {
            ((XmlElementVisitor)visitor).visitXmlFile((XmlFile)this);
        } else {
            visitor.visitFile((PsiFile)this);
        }
    }

    public String toString() {
        return "XmlFile:" + this.getName();
    }

    @NotNull
    public FileType getFileType() {
        if (this.myType == null) {
            this.myType = this.getLanguage().getAssociatedFileType();
            if (this.myType == null) {
                VirtualFile virtualFile = this.getOriginalFile().getVirtualFile();
                this.myType = virtualFile == null ? FileTypeRegistry.getInstance().getFileTypeByFileName(this.getName()) : virtualFile.getFileType();
            }
        }
        return this.myType;
    }

    public void clearCaches() {
        super.clearCaches();
        if (this.isWebFileType()) {
            ScriptSupportUtil.clearCaches(this);
        }
    }

    private boolean isWebFileType() {
        return this.getLanguage() == XHTMLLanguage.INSTANCE || this.getLanguage() == HTMLLanguage.INSTANCE;
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        return super.processDeclarations(processor, state, lastParent, place) && (!this.isWebFileType() || ScriptSupportUtil.processDeclarations(this, processor, state, lastParent, place));
    }

    @NotNull
    public GlobalSearchScope getFileResolveScope() {
        return ProjectScope.getAllScope((Project)this.getProject());
    }

    public boolean ignoreReferencedElementAccessibility() {
        return true;
    }
}

