/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.xml;

import com.intellij.codeInsight.daemon.Validator;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.util.XmlTagUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XMLExternalAnnotator
extends ExternalAnnotator<MyHost, MyHost> {
    @Nullable
    public MyHost collectInformation(@NotNull PsiFile file) {
        XmlNSDescriptor nsDescriptor;
        if (!(file instanceof XmlFile)) {
            return null;
        }
        XmlDocument document = ((XmlFile)file).getDocument();
        if (document == null) {
            return null;
        }
        XmlTag rootTag = document.getRootTag();
        XmlNSDescriptor xmlNSDescriptor = nsDescriptor = rootTag == null ? null : rootTag.getNSDescriptor(rootTag.getNamespace(), false);
        if (nsDescriptor instanceof Validator) {
            MyHost host = new MyHost();
            ((Validator)nsDescriptor).validate((PsiElement)document, (Validator.ValidationHost)host);
            return host;
        }
        return null;
    }

    @Nullable
    public MyHost doAnnotate(MyHost collectedInfo) {
        return collectedInfo;
    }

    public void apply(@NotNull PsiFile file, MyHost annotationResult, @NotNull AnnotationHolder holder) {
        annotationResult.apply(holder);
    }

    public static void addMessageWithFixes(PsiElement context, String message, @NotNull Validator.ValidationHost.ErrorType type, AnnotationHolder myHolder, IntentionAction ... fixes) {
        if (message != null && !message.isEmpty()) {
            HighlightSeverity severity;
            HighlightSeverity highlightSeverity = severity = type == Validator.ValidationHost.ErrorType.ERROR ? HighlightSeverity.ERROR : HighlightSeverity.WARNING;
            if (context instanceof XmlTag) {
                XMLExternalAnnotator.addMessagesForTreeChild((PsiElement)XmlTagUtil.getStartTagNameElement((XmlTag)((XmlTag)context)), severity, message, myHolder, fixes);
                XMLExternalAnnotator.addMessagesForTreeChild((PsiElement)XmlTagUtil.getEndTagNameElement((XmlTag)((XmlTag)context)), severity, message, myHolder, fixes);
            } else {
                XMLExternalAnnotator.addMessagesForTreeChild(context, severity, message, myHolder, fixes);
            }
        }
    }

    private static void addMessagesForTreeChild(PsiElement token, HighlightSeverity type, String message, AnnotationHolder myHolder, IntentionAction ... actions) {
        if (token != null) {
            AnnotationBuilder builder = myHolder.newAnnotation(type, message).range(token);
            for (IntentionAction action : actions) {
                builder = builder.withFix(action);
            }
            builder.create();
        }
    }

    static class MyHost
    implements Validator.ValidationHost {
        private final List<Trinity<PsiElement, String, Validator.ValidationHost.ErrorType>> messages = new ArrayList<Trinity<PsiElement, String, Validator.ValidationHost.ErrorType>>();

        MyHost() {
        }

        public void addMessage(PsiElement context, String message, @NotNull Validator.ValidationHost.ErrorType type) {
            this.messages.add((Trinity<PsiElement, String, Validator.ValidationHost.ErrorType>)Trinity.create((Object)context, (Object)message, (Object)type));
        }

        void apply(AnnotationHolder holder) {
            for (Trinity<PsiElement, String, Validator.ValidationHost.ErrorType> message : this.messages) {
                XMLExternalAnnotator.addMessageWithFixes((PsiElement)message.first, (String)message.second, (Validator.ValidationHost.ErrorType)message.third, holder, new IntentionAction[0]);
            }
        }
    }
}

