/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee;

import com.intellij.javaee.ExternalResourceManager;
import com.intellij.javaee.ExternalResourceManagerEx;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.Html5SchemaProvider;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.util.XmlUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultSchemasConfigurable
implements Configurable {
    private final Project myProject;
    private JRadioButton myHtml4RadioButton;
    private JRadioButton myHtml5RadioButton;
    private JRadioButton myOtherRadioButton;
    private JPanel myContentPanel;
    private JPanel myOtherDoctypeWrapper;
    private JBRadioButton myXMLSchema10JBRadioButton;
    private JBRadioButton myXMLSchema11JBRadioButton;
    private TextFieldWithAutoCompletion myDoctypeTextField;

    public DefaultSchemasConfigurable(Project project) {
        this.myProject = project;
        this.$$$setupUI$$$();
    }

    @NotNull
    private String getDoctype() {
        if (this.myHtml4RadioButton.isSelected()) {
            return XmlUtil.XHTML4_SCHEMA_LOCATION;
        }
        if (this.myHtml5RadioButton.isSelected()) {
            return Html5SchemaProvider.getHtml5SchemaLocation();
        }
        return this.myDoctypeTextField.getText();
    }

    @Nls
    public String getDisplayName() {
        return XmlBundle.message((String)"configurable.DefaultSchemasConfigurable.display.name", (Object[])new Object[0]);
    }

    @Nullable
    public String getHelpTopic() {
        return "reference.default.schemas";
    }

    @Nullable
    public JComponent createComponent() {
        String[] urls = ExternalResourceManager.getInstance().getResourceUrls(null, true);
        this.myDoctypeTextField = TextFieldWithAutoCompletion.create((Project)this.myProject, Arrays.asList(urls), null, (boolean)true, null);
        this.myOtherDoctypeWrapper.add((Component)this.myDoctypeTextField);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultSchemasConfigurable.this.myDoctypeTextField.setEnabled(DefaultSchemasConfigurable.this.myOtherRadioButton.isSelected());
            }
        };
        this.myHtml4RadioButton.addActionListener(listener);
        this.myHtml5RadioButton.addActionListener(listener);
        this.myOtherRadioButton.addActionListener(listener);
        if (UIUtil.isUnderWin10LookAndFeel()) {
            this.myOtherRadioButton.setBorder((Border)JBUI.Borders.empty());
        }
        return this.myContentPanel;
    }

    public boolean isModified() {
        return !ExternalResourceManagerEx.getInstanceEx().getDefaultHtmlDoctype(this.myProject).equals(this.getDoctype()) || ExternalResourceManagerEx.getInstanceEx().getXmlSchemaVersion(this.myProject) != this.getSchemaVersion();
    }

    public void apply() throws ConfigurationException {
        ExternalResourceManagerEx.getInstanceEx().setDefaultHtmlDoctype(this.getDoctype(), this.myProject);
        ExternalResourceManagerEx.getInstanceEx().setXmlSchemaVersion(this.getSchemaVersion(), this.myProject);
    }

    private ExternalResourceManagerEx.XMLSchemaVersion getSchemaVersion() {
        return this.myXMLSchema10JBRadioButton.isSelected() ? ExternalResourceManagerEx.XMLSchemaVersion.XMLSchema_1_0 : ExternalResourceManagerEx.XMLSchemaVersion.XMLSchema_1_1;
    }

    public void reset() {
        String doctype = ExternalResourceManagerEx.getInstanceEx().getDefaultHtmlDoctype(this.myProject);
        if (doctype.isEmpty() || doctype.equals(XmlUtil.XHTML4_SCHEMA_LOCATION)) {
            this.myHtml4RadioButton.setSelected(true);
            this.myDoctypeTextField.setEnabled(false);
        } else if (doctype.equals(Html5SchemaProvider.getHtml5SchemaLocation())) {
            this.myHtml5RadioButton.setSelected(true);
            this.myDoctypeTextField.setEnabled(false);
        } else {
            this.myOtherRadioButton.setSelected(true);
            this.myDoctypeTextField.setEnabled(true);
            UIUtil.invokeLaterIfNeeded(() -> {
                try {
                    this.myDoctypeTextField.setText(doctype);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        if (ExternalResourceManagerEx.getInstanceEx().getXmlSchemaVersion(this.myProject) == ExternalResourceManagerEx.XMLSchemaVersion.XMLSchema_1_0) {
            this.myXMLSchema10JBRadioButton.setSelected(true);
        } else {
            this.myXMLSchema11JBRadioButton.setSelected(true);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBRadioButton jBRadioButton;
        JBRadioButton jBRadioButton2;
        JPanel jPanel;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JPanel jPanel2;
        this.myContentPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"Default HTML language level", (int)0, (int)0, null, null));
        this.myHtml4RadioButton = jRadioButton3 = new JRadioButton();
        jRadioButton3.setText("HTML 4 (\"http://www.w3.org/TR/html4/loose.dtd\")");
        jPanel3.add((Component)jRadioButton3, new GridConstraints(0, 0, 1, 1, 9, 0, 3, 0, null, null, null));
        this.myHtml5RadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("HTML 5");
        jPanel3.add((Component)jRadioButton2, new GridConstraints(1, 0, 1, 1, 9, 0, 3, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myOtherRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setText("Other doctype:");
        jPanel4.add((Component)jRadioButton, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myOtherDoctypeWrapper = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 7, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel2.add((Component)jPanel5, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel5.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"XML Schema version", (int)0, (int)0, null, null));
        this.myXMLSchema10JBRadioButton = jBRadioButton2 = new JBRadioButton();
        jBRadioButton2.setText("XML Schema 1.0");
        jPanel5.add((Component)jBRadioButton2, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myXMLSchema11JBRadioButton = jBRadioButton = new JBRadioButton();
        jBRadioButton.setText("XML Schema 1.1");
        jPanel5.add((Component)jBRadioButton, new GridConstraints(1, 0, 1, 1, 0, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
        buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)jBRadioButton2);
        buttonGroup.add((AbstractButton)jBRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPanel;
    }
}

