/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.htmlInspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.htmlInspections.HtmlLocalInspectionTool;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.analysis.XmlAnalysisBundle;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class XmlWrongRootElementInspection
extends HtmlLocalInspectionTool {
    @NonNls
    @NotNull
    public String getShortName() {
        return "XmlWrongRootElement";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        return HighlightDisplayLevel.ERROR;
    }

    @Override
    protected void checkTag(@NotNull XmlTag tag, @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (!(tag.getParent() instanceof XmlTag)) {
            PsiFile psiFile = tag.getContainingFile();
            if (!(psiFile instanceof XmlFile)) {
                return;
            }
            XmlFile xmlFile = (XmlFile)psiFile;
            XmlDocument document = xmlFile.getDocument();
            if (document == null) {
                return;
            }
            XmlProlog prolog = document.getProlog();
            if (prolog == null || XmlHighlightVisitor.skipValidation((PsiElement)prolog)) {
                return;
            }
            XmlDoctype doctype = prolog.getDoctype();
            if (doctype == null) {
                return;
            }
            XmlElement nameElement = doctype.getNameElement();
            if (nameElement == null) {
                return;
            }
            String name = tag.getName();
            String text = nameElement.getText();
            if (tag instanceof HtmlTag) {
                name = StringUtil.toLowerCase((String)name);
                text = StringUtil.toLowerCase((String)text);
            }
            if (!name.equals(text) && !(name = XmlUtil.findLocalNameByQualifiedName(name)).equals(text)) {
                if (tag instanceof HtmlTag) {
                    return;
                }
                MyLocalQuickFix localQuickFix = new MyLocalQuickFix(doctype.getNameElement().getText());
                holder.registerProblem(XmlChildRole.START_TAG_NAME_FINDER.findChild(tag.getNode()).getPsi(), XmlAnalysisBundle.message((String)"wrong.root.element", (Object[])new Object[0]), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, new LocalQuickFix[]{localQuickFix});
                ASTNode astNode = XmlChildRole.CLOSING_TAG_NAME_FINDER.findChild(tag.getNode());
                if (astNode != null) {
                    holder.registerProblem(astNode.getPsi(), XmlAnalysisBundle.message((String)"wrong.root.element", (Object[])new Object[0]), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, new LocalQuickFix[]{localQuickFix});
                }
            }
        }
    }

    private static class MyLocalQuickFix
    implements LocalQuickFix {
        private final String myText;

        MyLocalQuickFix(String text) {
            this.myText = text;
        }

        @NotNull
        public String getFamilyName() {
            return XmlAnalysisBundle.message((String)"change.root.element.to", (Object[])new Object[]{this.myText});
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            XmlTag myTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), XmlTag.class);
            myTag.setName(this.myText);
        }
    }
}

