/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.htmlInspections;

import com.intellij.codeInsight.daemon.impl.analysis.RemoveAttributeIntentionFix;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.htmlInspections.AddCustomHtmlElementIntentionAction;
import com.intellij.codeInspection.htmlInspections.HtmlUnknownElementInspection;
import com.intellij.codeInspection.htmlInspections.SwitchToHtml5WithHighPriorityAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.text.EditDistance;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.analysis.XmlAnalysisBundle;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class HtmlUnknownAttributeInspectionBase
extends HtmlUnknownElementInspection {
    private static final Key<HtmlUnknownElementInspection> ATTRIBUTE_KEY = Key.create((String)"HtmlUnknownAttribute");
    private static final Logger LOG = Logger.getInstance(HtmlUnknownAttributeInspectionBase.class);

    public HtmlUnknownAttributeInspectionBase() {
        this("");
    }

    public HtmlUnknownAttributeInspectionBase(String defaultValues) {
        super(defaultValues);
    }

    @NonNls
    @NotNull
    public String getShortName() {
        return "HtmlUnknownAttribute";
    }

    @Override
    protected String getCheckboxTitle() {
        return XmlAnalysisBundle.message((String)"html.inspections.unknown.tag.attribute.checkbox.title", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    protected String getPanelTitle() {
        return XmlAnalysisBundle.message((String)"html.inspections.unknown.tag.attribute.title", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    protected void checkAttribute(@NotNull XmlAttribute attribute, @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        XmlTag tag = attribute.getParent();
        if (tag instanceof HtmlTag) {
            String name;
            XmlElementDescriptor elementDescriptor = tag.getDescriptor();
            if (elementDescriptor == null || elementDescriptor instanceof AnyXmlElementDescriptor) {
                return;
            }
            XmlAttributeDescriptor attributeDescriptor = attribute.getDescriptor();
            if (!(attributeDescriptor != null || attribute.isNamespaceDeclaration() || XmlUtil.attributeFromTemplateFramework(name = attribute.getName(), tag) || this.isCustomValuesEnabled() && this.isCustomValue(name))) {
                boolean maySwitchToHtml5 = HtmlUtil.isCustomHtml5Attribute(name) && !HtmlUtil.hasNonHtml5Doctype((XmlElement)tag);
                ArrayList<Object> quickfixes = new ArrayList<Object>(6);
                quickfixes.add(new AddCustomHtmlElementIntentionAction(ATTRIBUTE_KEY, name, XmlAnalysisBundle.message((String)"add.custom.html.attribute", (Object[])new Object[]{name})));
                quickfixes.add(new RemoveAttributeIntentionFix(name));
                if (maySwitchToHtml5) {
                    quickfixes.add(new SwitchToHtml5WithHighPriorityAction());
                }
                HtmlUnknownAttributeInspectionBase.addSimilarAttributesQuickFixes(tag, name, quickfixes);
                HtmlUnknownAttributeInspectionBase.registerProblemOnAttributeName(attribute, XmlAnalysisBundle.message((String)"attribute.is.not.allowed.here", (Object[])new Object[]{attribute.getName()}), holder, quickfixes.toArray(LocalQuickFix.EMPTY_ARRAY));
            }
        }
    }

    private static void addSimilarAttributesQuickFixes(XmlTag tag, String name, ArrayList<? super LocalQuickFix> quickfixes) {
        XmlElementDescriptor descriptor = tag.getDescriptor();
        if (descriptor == null) {
            return;
        }
        XmlAttributeDescriptor[] descriptors = descriptor.getAttributesDescriptors(tag);
        int initialSize = quickfixes.size();
        for (XmlAttributeDescriptor attr : descriptors) {
            if (EditDistance.optimalAlignment((CharSequence)name, (CharSequence)attr.getName(), (boolean)false) <= 1) {
                quickfixes.add(new RenameAttributeFix(attr));
            }
            if (quickfixes.size() >= initialSize + 3) break;
        }
    }

    private static class RenameAttributeFix
    implements LocalQuickFix,
    HighPriorityAction {
        private final String name;

        RenameAttributeFix(XmlAttributeDescriptor attr) {
            this.name = attr.getName();
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return XmlAnalysisBundle.message((String)"rename.attribute", (Object[])new Object[0]);
        }

        @Nls
        @NotNull
        public String getName() {
            return XmlAnalysisBundle.message((String)"rename.attribute.to.0", (Object[])new Object[]{this.name});
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), XmlAttribute.class);
            if (attribute == null) {
                return;
            }
            attribute.setName(this.name);
        }
    }
}

