/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.htmlInspections;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.htmlInspections.XmlEntitiesInspection;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.xml.analysis.XmlAnalysisBundle;
import org.jetbrains.annotations.NotNull;

public class AddHtmlTagOrAttributeToCustomsIntention
implements LocalQuickFix {
    private final String myName;
    private final String myText;
    private final Key<InspectionProfileEntry> myInspectionKey;

    public AddHtmlTagOrAttributeToCustomsIntention(Key<InspectionProfileEntry> inspectionKey, String name, String text) {
        this.myInspectionKey = inspectionKey;
        this.myName = name;
        this.myText = text;
    }

    @NotNull
    public String getName() {
        return this.myText;
    }

    @NotNull
    public String getFamilyName() {
        return XmlAnalysisBundle.message((String)"fix.html.family", (Object[])new Object[0]);
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        InspectionProfileImpl profile = InspectionProjectProfileManager.getInstance((Project)project).getCurrentProfile();
        profile.modifyToolSettings(this.myInspectionKey, (PsiElement)descriptor.getPsiElement().getContainingFile(), entry -> {
            XmlEntitiesInspection xmlEntitiesInspection = (XmlEntitiesInspection)entry;
            xmlEntitiesInspection.addEntry(this.myName);
        });
    }

    public boolean startInWriteAction() {
        return false;
    }
}

