/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet;

import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.emmet.ZenCodingTemplate;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.BalloonImpl;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.LightColors;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithStoredHistory;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmmetAbbreviationBalloon {
    private final String myAbbreviationsHistoryKey;
    private final String myLastAbbreviationKey;
    private final Callback myCallback;
    @NotNull
    private final EmmetContextHelp myContextHelp;
    @Nullable
    private static String ourTestingAbbreviation;

    public EmmetAbbreviationBalloon(@NotNull String abbreviationsHistoryKey, @NotNull String lastAbbreviationKey, @NotNull Callback callback, @NotNull EmmetContextHelp contextHelp) {
        this.myAbbreviationsHistoryKey = abbreviationsHistoryKey;
        this.myLastAbbreviationKey = lastAbbreviationKey;
        this.myCallback = callback;
        this.myContextHelp = contextHelp;
    }

    public static void setTestingAbbreviation(@NotNull String testingAbbreviation, @NotNull Disposable parentDisposable) {
        ourTestingAbbreviation = testingAbbreviation;
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                ourTestingAbbreviation = null;
            }
        });
    }

    public void show(final @NotNull CustomTemplateCallback customTemplateCallback) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            if (ourTestingAbbreviation == null) {
                throw new RuntimeException("Testing abbreviation is not set. See EmmetAbbreviationBalloon#setTestingAbbreviation");
            }
            this.myCallback.onEnter(ourTestingAbbreviation);
            return;
        }
        JPanel panel = new JPanel(new BorderLayout());
        final TextFieldWithStoredHistory field = new TextFieldWithStoredHistory(this.myAbbreviationsHistoryKey);
        Dimension fieldPreferredSize = field.getPreferredSize();
        field.setPreferredSize(new Dimension(Math.max(220, fieldPreferredSize.width), fieldPreferredSize.height));
        field.setHistorySize(10);
        ContextHelpLabel label = this.myContextHelp.createHelpLabel();
        label.setBorder((Border)JBUI.Borders.empty((int)0, (int)3, (int)0, (int)1));
        panel.add((Component)field, "Center");
        panel.add((Component)label, "East");
        JBPopupFactory popupFactory = JBPopupFactory.getInstance();
        final BalloonImpl balloon = (BalloonImpl)popupFactory.createBalloonBuilder((JComponent)panel).setCloseButtonEnabled(false).setBlockClicksThroughBalloon(true).setAnimationCycle(0).setHideOnKeyOutside(true).setHideOnClickOutside(true).setFillColor(panel.getBackground()).createBalloon();
        final DocumentAdapter documentListener = new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (!EmmetAbbreviationBalloon.isValid(customTemplateCallback)) {
                    balloon.hide();
                    return;
                }
                EmmetAbbreviationBalloon.validateTemplateKey((TextFieldWithHistory)field, (Balloon)balloon, field.getText(), customTemplateCallback);
            }
        };
        field.addDocumentListener((DocumentListener)documentListener);
        final KeyAdapter keyListener = new KeyAdapter(){

            @Override
            public void keyPressed(@NotNull KeyEvent e) {
                if (!field.isPopupVisible()) {
                    if (!EmmetAbbreviationBalloon.isValid(customTemplateCallback)) {
                        balloon.hide();
                        return;
                    }
                    switch (e.getKeyCode()) {
                        case 10: {
                            String abbreviation = field.getText();
                            if (!EmmetAbbreviationBalloon.validateTemplateKey((TextFieldWithHistory)field, (Balloon)balloon, abbreviation, customTemplateCallback)) break;
                            EmmetAbbreviationBalloon.this.myCallback.onEnter(abbreviation);
                            PropertiesComponent.getInstance().setValue(EmmetAbbreviationBalloon.this.myLastAbbreviationKey, abbreviation);
                            field.addCurrentTextToHistory();
                            balloon.hide();
                            break;
                        }
                        case 27: {
                            balloon.hide(false);
                        }
                    }
                }
            }
        };
        field.addKeyboardListener((KeyListener)keyListener);
        balloon.addListener(new JBPopupListener(){

            public void beforeShown(@NotNull LightweightWindowEvent event) {
                field.setText(PropertiesComponent.getInstance().getValue(EmmetAbbreviationBalloon.this.myLastAbbreviationKey, ""));
            }

            public void onClosed(@NotNull LightweightWindowEvent event) {
                field.removeKeyListener((KeyListener)keyListener);
                field.removeDocumentListener((DocumentListener)documentListener);
            }
        });
        balloon.show(popupFactory.guessBestPopupLocation(customTemplateCallback.getEditor()), Balloon.Position.below);
        IdeFocusManager focusManager = IdeFocusManager.getInstance((Project)customTemplateCallback.getProject());
        focusManager.doWhenFocusSettlesDown(() -> {
            focusManager.requestFocus((Component)field, true);
            field.selectText();
        });
    }

    private static boolean validateTemplateKey(@NotNull TextFieldWithHistory field, @Nullable Balloon balloon, @NotNull String abbreviation, @NotNull CustomTemplateCallback callback) {
        boolean correct = ZenCodingTemplate.checkTemplateKey(abbreviation, callback);
        field.getTextEditor().setBackground(correct ? LightColors.SLIGHTLY_GREEN : LightColors.RED);
        if (balloon != null && !balloon.isDisposed()) {
            balloon.revalidate();
        }
        return correct;
    }

    private static boolean isValid(CustomTemplateCallback callback) {
        return !callback.getEditor().isDisposed();
    }

    public static interface Callback {
        public void onEnter(@NotNull String var1);
    }

    public static class EmmetContextHelp {
        @NotNull
        private final String myDescription;
        @Nullable
        private String myLinkText = null;
        @Nullable
        private String myLinkUrl = null;

        public EmmetContextHelp(@NotNull String description) {
            this.myDescription = description;
        }

        public EmmetContextHelp(@NotNull String description, @NotNull String linkText, @NotNull String linkUrl) {
            this.myDescription = description;
            this.myLinkText = linkText;
            this.myLinkUrl = linkUrl;
        }

        @NotNull
        public ContextHelpLabel createHelpLabel() {
            if (StringUtil.isEmpty((String)this.myLinkText) || StringUtil.isEmpty((String)this.myLinkUrl)) {
                return ContextHelpLabel.create((String)this.myDescription);
            }
            return ContextHelpLabel.createWithLink(null, (String)this.myDescription, (String)this.myLinkText, () -> BrowserUtil.browse((String)this.myLinkUrl));
        }
    }
}

