/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.XmlErrorBundle;
import com.intellij.codeInsight.editorActions.XmlEditUtil;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.util.HtmlUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InsertRequiredAttributeFix
extends LocalQuickFixAndIntentionActionOnPsiElement
implements HighPriorityAction {
    private final String myAttrName;
    private final String[] myValues;
    @NonNls
    private static final String NAME_TEMPLATE_VARIABLE = "name";

    public InsertRequiredAttributeFix(@NotNull XmlTag tag, @NotNull String attrName, String ... values) {
        super((PsiElement)tag);
        this.myAttrName = attrName;
        this.myValues = values;
    }

    @NotNull
    public String getText() {
        return XmlErrorBundle.message("insert.required.attribute.quickfix.text", this.myAttrName);
    }

    @NotNull
    public String getFamilyName() {
        return XmlErrorBundle.message("insert.required.attribute.quickfix.family", new Object[0]);
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        boolean anchorIsEmptyTag;
        XmlTag myTag = (XmlTag)startElement;
        ASTNode treeElement = SourceTreeToPsiMap.psiElementToTree((PsiElement)myTag);
        XmlElementDescriptor descriptor = myTag.getDescriptor();
        if (descriptor == null) {
            return;
        }
        XmlAttributeDescriptor attrDescriptor = descriptor.getAttributeDescriptor(this.myAttrName, myTag);
        boolean indirectSyntax = XmlExtension.getExtension(myTag.getContainingFile()).isIndirectSyntax(attrDescriptor);
        boolean insertShorthand = myTag instanceof HtmlTag && attrDescriptor != null && HtmlUtil.isBooleanAttribute(attrDescriptor, (PsiElement)myTag);
        PsiElement anchor = SourceTreeToPsiMap.treeElementToPsi((ASTNode)XmlChildRole.EMPTY_TAG_END_FINDER.findChild(treeElement));
        boolean bl = anchorIsEmptyTag = anchor != null;
        if (anchor == null) {
            anchor = SourceTreeToPsiMap.treeElementToPsi((ASTNode)XmlChildRole.START_TAG_END_FINDER.findChild(treeElement));
        }
        if (anchor == null) {
            return;
        }
        Template template = TemplateManager.getInstance((Project)project).createTemplate("", "");
        String valuePostfix = "\"";
        if (indirectSyntax) {
            if (anchorIsEmptyTag) {
                template.addTextSegment(">");
            }
            template.addTextSegment("<jsp:attribute name=\"" + this.myAttrName + "\">");
        } else {
            template.addTextSegment(" " + this.myAttrName);
            if (!insertShorthand) {
                String quote = XmlEditUtil.getAttributeQuote(file);
                XmlExtension.AttributeValuePresentation presentation = XmlExtension.getExtension(file).getAttributeValuePresentation(myTag, this.myAttrName, quote);
                valuePostfix = presentation.getPostfix();
                template.addTextSegment("=" + presentation.getPrefix());
            }
        }
        ConstantNode expression = new ConstantNode("").withLookupStrings(this.myValues);
        if (!insertShorthand) {
            template.addVariable(NAME_TEMPLATE_VARIABLE, (Expression)expression, (Expression)expression, true);
        }
        if (indirectSyntax) {
            template.addTextSegment("</jsp:attribute>");
            template.addEndVariable();
            if (anchorIsEmptyTag) {
                template.addTextSegment("</" + myTag.getName() + ">");
            }
        } else if (!insertShorthand) {
            template.addTextSegment(valuePostfix);
        }
        PsiElement anchor1 = anchor;
        ApplicationManager.getApplication().invokeLater(() -> WriteCommandAction.runWriteCommandAction((Project)project, (String)this.getText(), (String)this.getFamilyName(), () -> {
            int textOffset = anchor1.getTextOffset();
            if (!anchorIsEmptyTag && indirectSyntax) {
                ++textOffset;
            }
            editor.getCaretModel().moveToOffset(textOffset);
            if (anchorIsEmptyTag && indirectSyntax) {
                editor.getDocument().deleteString(textOffset, textOffset + 2);
            }
            TemplateManager.getInstance((Project)project).startTemplate(editor, template);
        }, (PsiFile[])new PsiFile[0]));
    }
}

