/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlBundle;
import java.util.ArrayList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class CDataToTextIntention
implements IntentionAction {
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        return XmlBundle.message((String)"convert.cdata.to.text", (Object[])new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        return CDataToTextIntention.getCData(editor, file) != null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        ASTNode curr;
        PsiElement cdata = CDataToTextIntention.getCData(editor, file);
        if (cdata == null) {
            return;
        }
        ASTNode node = cdata.getNode();
        ArrayList<ASTNode> cdatas = new ArrayList<ASTNode>();
        for (curr = node.getTreePrev(); curr != null && curr.getElementType() == XmlElementType.XML_CDATA; curr = curr.getTreePrev()) {
            cdatas.add(0, curr);
        }
        cdatas.add(node);
        for (curr = node.getTreeNext(); curr != null && curr.getElementType() == XmlElementType.XML_CDATA; curr = curr.getTreeNext()) {
            cdatas.add(curr);
        }
        StringBuilder text = new StringBuilder();
        for (ASTNode astNode : cdatas) {
            ASTNode textNode = astNode.getFirstChildNode().getTreeNext();
            if (textNode == null || textNode.getElementType() == XmlTokenType.XML_CDATA_END) continue;
            text.append(StringUtil.escapeXmlEntities((String)textNode.getText()));
        }
        editor.getDocument().replaceString(((ASTNode)cdatas.get(0)).getStartOffset(), ((ASTNode)cdatas.get(cdatas.size() - 1)).getTextRange().getEndOffset(), (CharSequence)text.toString());
    }

    private static PsiElement getCData(Editor editor, PsiFile file) {
        PsiElement parent;
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        PsiElement psiElement = parent = element != null ? element.getParent() : null;
        if (parent != null && parent.getNode() != null && parent.getNode().getElementType() == XmlElementType.XML_CDATA) {
            return parent;
        }
        element = file.findElementAt(offset - 1);
        PsiElement psiElement2 = parent = element != null ? element.getParent() : null;
        if (parent != null && parent.getNode() != null && parent.getNode().getElementType() == XmlElementType.XML_CDATA) {
            return parent;
        }
        return null;
    }

    public boolean startInWriteAction() {
        return true;
    }
}

