/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.JavaCoverageRunner;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.configurations.coverage.JavaCoverageEnabledConfiguration;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.instrumentation.SaveHook;
import com.intellij.rt.coverage.util.ProjectDataLoader;
import com.intellij.util.PathUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IDEACoverageRunner
extends JavaCoverageRunner {
    private static final Logger LOG = Logger.getInstance(IDEACoverageRunner.class);

    public ProjectData loadCoverageData(@NotNull File sessionDataFile, @Nullable CoverageSuite coverageSuite) {
        ProjectData projectData = ProjectDataLoader.load((File)sessionDataFile);
        File sourceMapFile = new File(JavaCoverageEnabledConfiguration.getSourceMapPath(sessionDataFile.getPath()));
        if (sourceMapFile.exists()) {
            try {
                this.loadSourceMap(projectData, sourceMapFile);
            }
            catch (IOException e) {
                LOG.warn("Error reading source map associated with coverage data", (Throwable)e);
            }
        }
        return projectData;
    }

    public void loadSourceMap(ProjectData projectData, File sourceMapFile) throws IOException {
        Map map = SaveHook.loadSourceMapFromFile(new HashMap(), (File)sourceMapFile);
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = iterator.next();
            String className = (String)entry.getKey();
            String source = (String)entry.getValue();
            ClassData data = projectData.getClassData(className);
            if (data == null) continue;
            data.setSource(source);
        }
    }

    @Override
    public void appendCoverageArgument(String sessionDataFilePath, String @Nullable [] patterns, SimpleJavaParameters parameters, boolean collectLineInfo, boolean isSampling) {
        this.appendCoverageArgument(sessionDataFilePath, patterns, null, parameters, collectLineInfo, isSampling, null);
    }

    @Override
    public void appendCoverageArgument(String sessionDataFilePath, String[] patterns, String[] excludePatterns, SimpleJavaParameters javaParameters, boolean collectLineInfo, boolean isSampling, @Nullable String sourceMapPath) {
        StringBuilder argument = new StringBuilder("-javaagent:");
        String agentPath = IDEACoverageRunner.handleSpacesInAgentPath(PathUtil.getJarPathForClass(ProjectData.class));
        if (agentPath == null) {
            return;
        }
        argument.append(agentPath);
        argument.append("=");
        try {
            File tempFile = IDEACoverageRunner.createTempFile();
            tempFile.deleteOnExit();
            IDEACoverageRunner.write2file(tempFile, sessionDataFilePath);
            IDEACoverageRunner.write2file(tempFile, String.valueOf(collectLineInfo));
            IDEACoverageRunner.write2file(tempFile, Boolean.FALSE.toString());
            IDEACoverageRunner.write2file(tempFile, Boolean.FALSE.toString());
            IDEACoverageRunner.write2file(tempFile, String.valueOf(isSampling));
            if (sourceMapPath != null) {
                IDEACoverageRunner.write2file(tempFile, Boolean.TRUE.toString());
                IDEACoverageRunner.write2file(tempFile, sourceMapPath);
            }
            if (patterns != null) {
                IDEACoverageRunner.writePatterns(tempFile, patterns);
            }
            if (excludePatterns != null) {
                IDEACoverageRunner.write2file(tempFile, "-exclude");
                IDEACoverageRunner.writePatterns(tempFile, excludePatterns);
            }
            argument.append(tempFile.getCanonicalPath());
        }
        catch (IOException e) {
            LOG.info("Coverage was not enabled", (Throwable)e);
            return;
        }
        javaParameters.getVMParametersList().add(argument.toString());
    }

    private static void writePatterns(File tempFile, String[] patterns) throws IOException {
        for (String coveragePattern : patterns) {
            if (!(coveragePattern = coveragePattern.replace("$", "\\$").replace(".", "\\.").replaceAll("\\*", ".*")).endsWith(".*")) {
                coveragePattern = coveragePattern + "(\\$.*)*";
            }
            IDEACoverageRunner.write2file(tempFile, coveragePattern);
        }
    }

    @NotNull
    public String getPresentableName() {
        return "IntelliJ IDEA";
    }

    @NotNull
    public String getId() {
        return "idea";
    }

    @NotNull
    public String getDataFileExtension() {
        return "ic";
    }

    public boolean isCoverageByTestApplicable() {
        return true;
    }
}

