/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.lang.manifest.psi.impl;

import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.lang.manifest.ManifestFileType;
import org.jetbrains.lang.manifest.ManifestLanguage;
import org.jetbrains.lang.manifest.psi.Header;
import org.jetbrains.lang.manifest.psi.ManifestFile;
import org.jetbrains.lang.manifest.psi.Section;

public class ManifestFileImpl
extends PsiFileBase
implements ManifestFile {
    public ManifestFileImpl(FileViewProvider viewProvider) {
        super(viewProvider, (Language)ManifestLanguage.INSTANCE);
    }

    @NotNull
    public FileType getFileType() {
        return ManifestFileType.INSTANCE;
    }

    @Override
    @NotNull
    public List<Section> getSections() {
        return PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)this, Section.class);
    }

    @Override
    @Nullable
    public Section getMainSection() {
        return (Section)this.findChildByClass(Section.class);
    }

    @Override
    @NotNull
    public List<Header> getHeaders() {
        return PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)this.getFirstChild(), Header.class);
    }

    @Override
    @Nullable
    public Header getHeader(@NotNull String name2) {
        Header child = (Header)PsiTreeUtil.findChildOfType((PsiElement)this.getFirstChild(), Header.class);
        while (child != null) {
            if (name2.equals(child.getName())) {
                return child;
            }
            child = (Header)PsiTreeUtil.getNextSiblingOfType((PsiElement)child, Header.class);
        }
        return null;
    }

    public String toString() {
        return "ManifestFile:" + this.getName();
    }
}

